% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelfitting.R
\name{fitModel}
\alias{fitModel}
\title{Fit models}
\usage{
fitModel(
  y,
  x,
  data,
  family = "gaussian",
  link = switch(family, gaussian = "gaussian", binomial = "logit", poisson = "log"),
  design = "simple",
  svydes = NA,
  ...
)
}
\arguments{
\item{y}{character string representing the response,}

\item{x}{character string of the explanatory variables,}

\item{data}{name of the object containing the data.}

\item{family}{gaussian, binomial, poisson (so far, no others will be added)}

\item{link}{the link function to use}

\item{design}{data design specification.
one of 'simple', 'survey' or 'experiment'}

\item{svydes}{a vector of arguments to be passed to the svydesign function,
excluding data (defined above)}

\item{...}{further arguments to be passed to lm, glm, svyglm,
such as offset, etc.}
}
\value{
A model call formula (using lm, glm, or svyglm)
}
\description{
Wrapper function for `lm`, `glm`, and `svyglm`.
}
\author{
Tom Elliott
}
