% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_dict.R
\name{read_dictionary}
\alias{read_dictionary}
\alias{print.dictionary}
\alias{[.dictionary}
\alias{apply_dictionary}
\alias{has_dictionary}
\alias{get_dictionary}
\title{Data Dictionaries}
\usage{
read_dictionary(
  file,
  name = "name",
  type = "type",
  title = "title",
  description = "description",
  units = "units",
  codes = "codes",
  values = "values",
  level_separator = "|",
  ...
)

\method{print}{dictionary}(x, kable = FALSE, include_other = TRUE, ...)

\method{[}{dictionary}(x, i, ...)

apply_dictionary(data, dict)

has_dictionary(data)

get_dictionary(data)
}
\arguments{
\item{file}{The path to the file containing the data dictionary.}

\item{name}{The name of the column containing the variable name.}

\item{type}{The name of the column containing the variable type.}

\item{title}{The name of the column containing a short, human-readable title
for the variable. If blank, the variable name will be used instead.}

\item{description}{The name of the column containing the variable
description.}

\item{units}{The name of the column containing units (for numeric
variables only).}

\item{codes}{The name of the column containing factor codes (for categorical
variables only).}

\item{values}{The name of the column containing factor values
corresponding to the codes. These should be in the same order
as the codes.}

\item{level_separator}{The separator used to separate levels in \code{codes} and
\code{values} columns. The default separator is "|".
Alternatively, you can provide a vector of length 2, where the first
element is used for \code{codes} and the second element for \code{values}.}

\item{...}{Additional arguments, passed to \code{smart_read}.}

\item{x}{A \code{dictionary} object.}

\item{kable}{If \code{TRUE}, the output will be formatted using kable.}

\item{include_other}{If \code{TRUE}, additional variables will be included in
the output.}

\item{i}{Subset index.}

\item{data}{A dataset (dataframe, tibble).}

\item{dict}{A dictionary (created using \code{read_dictionary()}).}
}
\value{
The dataset with the attached data dictionary.
}
\description{
This function reads a data dictionary from a file and attaches it to a
dataset. The attached data dictionary provides utility functions that can be
used by other methods, such as plots, to automatically create axes and more.
}
