% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_vars.R
\name{sort_vars}
\alias{sort_vars}
\title{Sort data by variables}
\usage{
sort_vars(data, vars, asc = rep(TRUE, length(vars)))
}
\arguments{
\item{data}{a dataframe to sort}

\item{vars}{a character vector of variable names to sort by}

\item{asc}{logical, length of 1 or same length as \code{vars}.
If \code{TRUE} (default), then sorted in ascending order,
otherwise descending.}
}
\value{
data with tidyverse code attached
}
\description{
Sorts a dataframe by one or more variables, and returns the result
along with tidyverse code used to generate it.
}
\examples{
sorted <- sort_vars(iris,
    vars = c("Sepal.Width", "Sepal.Length"),
    asc = c(TRUE, FALSE)
)
cat(code(sorted))
head(sorted)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin, Zhaoming Su
}
