% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_helper_functions.R
\name{vol2C_nondiatom}
\alias{vol2C_nondiatom}
\title{Convert Biovolume to Carbon for Non-Diatom Protists}
\usage{
vol2C_nondiatom(volume)
}
\arguments{
\item{volume}{A numeric vector of biovolume measurements in microns^3.}
}
\value{
A numeric vector of carbon measurements in picograms.
}
\description{
This function converts biovolume in microns^3 to carbon in picograms
for protists besides large diatoms (> 3000 micron^3) according to Menden-Deuer and Lessard 2000.
The formula used is: log pgC cell^-1 = log a + b * log V (um^3),
with log a = -0.665 and b = 0.939.
}
\examples{
# Volumes in microns^3
volume <- c(5000, 10000, 20000)

# Convert biovolume to carbon for non-diatom protists
vol2C_nondiatom(volume)
}
