% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MICA.R
\name{MICA}
\alias{MICA}
\title{Multimodal independent component analysis
The input datasets are assumed to be two matrices sharing the column space.
MICA decomposes the matrices simutanously
and extracts the components that maximizes the mutual information
between the components.}
\usage{
MICA(
  X,
  Y,
  J,
  eta = 1000 * 1e-04,
  verbose = FALSE,
  mu = 50 * 1e-04,
  gamma_ts = 1
)
}
\arguments{
\item{X}{A matrix sharing the column space with Y (??? x N)}

\item{Y}{A matrix sharing the column space with X (??? x N)}

\item{J}{The rank parameter to decompose the matrices}

\item{eta}{A learning rate parameter of stochastic gradient descent}

\item{verbose}{Verbose option}

\item{mu}{A learning rate parameter of stochastic gradient descent}

\item{gamma_ts}{Weighting factor for dependence on independence}
}
\value{
A list containing the result of the decomposition
}
\description{
Multimodal independent component analysis
The input datasets are assumed to be two matrices sharing the column space.
MICA decomposes the matrices simutanously
and extracts the components that maximizes the mutual information
between the components.
}
\examples{
X <- array(runif(10*20), dim=c(10,20))
Y <- array(runif(15*20), dim=c(15,20))
J <- 20
out <- MICA(X, Y, J=J)
}
