% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haploDraw.R
\name{haploDraw}
\alias{haploDraw}
\title{Draw haplotypes onto a pedigree plot}
\usage{
haploDraw(
  x,
  ibd,
  chrom = NULL,
  ids = NULL,
  pos = 1,
  cols = NULL,
  height = 4,
  width = 0.5,
  sep = 0.75,
  dist = 1.5,
  ...
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{ibd}{A \code{genomeSim} object.}

\item{chrom}{A chromosome number, needed if \code{ibd} contains data from multiple
chromosomes.}

\item{ids}{A vector indicating for which pedigree members haplotypes should
be drawn. If NULL (default), all individuals in \code{ibd} are included.}

\item{pos}{A vector recycled to \code{pedsize(x)}, indicating where haplotypes
should be drawn relative to the pedigree symbols: 0 = no haplotypes; 1 =
below; 2 = left; 3 = above; 4 = right. By default, all are placed below.}

\item{cols}{A colour vector corresponding to the alleles in \code{ibd}.}

\item{height}{The haplotype height divided by the height of a pedigree
symbol.}

\item{width}{The haplotype width divided by the width of a pedigree symbol.}

\item{sep}{The separation between haplotypes within a pair, given as a
fraction of \code{width}.}

\item{dist}{The distance between pedigree symbols and the closest haplotype,
given as a fraction of \code{width}.}

\item{...}{Arguments passed on to \code{plot.ped()}. In particular, if the
haplotypes appear cropped it usually helps to increase the \code{margins}.}
}
\value{
None.
}
\description{
Visualise the IBD pattern of a single chromosome, by drawing haplotypes onto
the pedigree.
}
\examples{
op = par(no.readonly = TRUE)

###############################
# Example 1: A family quartet #
###############################

x = nuclearPed(2)
s = ibdsim(x, N = 1, map = uniformMap(M = 1), seed = 4276)
s[[1]]

haploDraw(x, s[[1]], pos = c(2,4,2,4), cols = c(3,7,2,4),
          margins = c(2, 5, 5, 5), cex = 1.2)


###########################
# Example 2: Autozygosity #
###########################

x = halfCousinPed(0, child = TRUE)
s = ibdsim(x, N = 1, map = uniformMap(M = 1),
           skipRecomb = spouses(x, 2), seed = 19499)
s[[1]]

# Grey colour (8) for irrelevant founder alleles
haploDraw(x, s[[1]], pos = c(0,1,0,2,4,4),
          cols = c(8,8,3,7,8,8), margin = c(2, 2, 2, 2))


###############################
# Example 3: X-chromosomal sims
###############################

x = nuclearPed(2, sex = 2:1)
s = ibdsim(x, N = 1, map = uniformMap(M = 1, chrom = "X"), seed = 1)
s[[1]]

haploDraw(x, s[[1]], pos = c(2,4,2,4), margins = c(2, 5, 5, 5), cex = 1.2)


# Restore graphics parameters
par(op)

}
