% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{icd9Condense}
\alias{icd9Condense}
\alias{icd9CondenseDecimal}
\alias{icd9CondenseShort}
\title{Deprecated: condense list of ICD-9 codes}
\usage{
icd9Condense(icd9, isShort = icd_guess_short(icd9), onlyReal = NULL,
  warn = TRUE)

icd9CondenseDecimal(icd9Decimal, onlyReal = NULL, warn = TRUE,
  keepFactorLevels = FALSE)

icd9CondenseShort(icd9Short, onlyReal = NULL, warn = TRUE,
  keepFactorLevels = FALSE)
}
\arguments{
\item{icd9}{is a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{Deprecated. Single logical value which determines whether the
ICD-9 code provided is in short (\code{TRUE}) or decimal (\code{FALSE})
form. Where reasonable, this is guessed from the input data.}

\item{onlyReal}{single logical value, if \code{TRUE}, will limit the search
to those codes which appear in the master list, not just syntactically
valid codes. Since nearly valid, out-dated or new codes may be missed, not
limiting to officially defined values will be useful. Ultimately, there
will need to be annual (and all-time) master lists of codes and the ability
to test against a given master list given the year of the ICD-9 coding.}

\item{warn}{single logical value, if \code{TRUE}, give warnings when
there is discrepancy between \code{onlyReal} being \code{TRUE} yet data
containing undefined codes.}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{keepFactorLevels}{logical}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}
}
\description{
Use \code{icd_condense} instead
}

