% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{set_icd_class}
\alias{as.icd10}
\alias{as.icd10cm}
\alias{as.icd9}
\alias{as.icd9cm}
\alias{as.icd_comorbidity_map}
\alias{as.icd_long_data}
\alias{as.icd_wide_data}
\alias{icd10}
\alias{icd10cm}
\alias{icd9}
\alias{icd9cm}
\alias{icd_comorbidity_map}
\alias{icd_long_data}
\alias{icd_wide_data}
\alias{set_icd_class}
\title{Construct ICD-9 data types}
\usage{
icd9(x)

as.icd9(x)

icd9cm(x)

as.icd9cm(x)

as.icd10(x)

icd10(x)

as.icd10cm(x, short_code = NULL)

icd10cm(x)

as.icd_long_data(x)

as.icd_wide_data(x)

icd_long_data(...)

icd_wide_data(...)

icd_comorbidity_map(x)

as.icd_comorbidity_map(x)
}
\arguments{
\item{x}{object to set class \code{icd9}}

\item{...}{arguments passed on to create a \code{data.frame}}

\item{warn}{single logical value, if \code{TRUE} will gives warning when
converting between types. ICD-9 to ICD-10 will cause an error regardless.}
}
\description{
Takes an R structure and sets class to an ICD type. In the case of ICD-9 and
ICD-10 codes, if a particular sub-type is set, e.g. ICD-9-CM (\code{icd9cm}),
then an ICD-9 class (\code{icd9}) is also set.

\code{icd_long_data} and \code{icd_short_data} create
  \code{data.frame}s using all the arguments, and sets the class, whereas
  \code{as.icd_long_data} and \code{as.icd_wide_data} just set the class of
  an existing \code{data.frame}.
}
\details{
The \code{as.} function e.g. \code{as.icd9}, do checking and try to put
multiple classes in a nice order. Calling the bare constructor, e.g.
\code{icd9} just prepends the new class and returns without any checks. The
latter is much faster, but for most uses, \code{as.icd9} and siblings would
be better.

Some features make more sense as attributes. E.g. setting code type to
\code{short} or \code{decimal}.

long or wide format data is always a data frame. It does not
  carry any other ICD classes, even if it only contains one type of code.

Using \code{attributes} instead of \code{class} is a better fit for
  the data. It simplifies S3 dispatch, and appears to be very fast to get or
  set using the built-in R functions.
}
\examples{
x = as.icd10("A1009")
attr(x, "icd_short_diag") <- TRUE
x
attributes(x) <- list(icd_short_diag = NULL)
x

# despite exhortation to implement [<- etc, the following seems to work:
j <- as.icd_short_diag(as.icd10(c("A11", "B2222")))
j[2] <- "C33"
stopifnot(is.icd_short_diag(j))
stopifnot(is.icd10(j), is.icd10(j[1]), is.icd10(j[[1]]))
j[[1]] <- "D44001"
stopifnot(is.icd_short_diag(j))
stopifnot(is.icd10(j), is.icd10(j[2]), is.icd10(j[[2]]))
}
\keyword{internal}

