% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R, R/z-deprecated.R
\name{decimal_to_short}
\alias{decimal_to_short}
\alias{decimal_to_short.icd9}
\alias{decimal_to_short.icd10}
\alias{decimal_to_short.icd10cm}
\alias{decimal_to_short.default}
\alias{icd_decimal_to_short.default}
\alias{icd_decimal_to_short.icd10}
\alias{icd_decimal_to_short.icd10cm}
\alias{icd_decimal_to_short.icd9}
\alias{icd_decimal_to_short}
\title{Convert Decimal format ICD codes to short format}
\usage{
decimal_to_short(x)

\method{decimal_to_short}{icd9}(x)

\method{decimal_to_short}{icd10}(x)

\method{decimal_to_short}{icd10cm}(x)

\method{decimal_to_short}{default}(x)

icd_decimal_to_short.default(...)

icd_decimal_to_short.icd10(...)

icd_decimal_to_short.icd10cm(...)

icd_decimal_to_short.icd9(...)

icd_decimal_to_short(...)
}
\arguments{
\item{x}{ICD codes}
}
\description{
This usually just entails removing the decimal point, but also does some
limited validation and tidying up.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: convert ICD-9 codes from decimal to short
format

\item \code{icd10}: convert ICD-10 codes from decimal to short
format

\item \code{icd10cm}: convert ICD-10-CM codes from decimal to short
format

\item \code{default}: Guess ICD version and convert decimal to
short format
}}

\keyword{internal}
\keyword{manip}
