% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{get_invalid}
\alias{get_invalid}
\alias{get_invalid.default}
\alias{get_invalid.icd9}
\alias{get_invalid.icd10}
\alias{get_invalid.comorbidity_map}
\title{Get invalid ICD codes}
\usage{
get_invalid(...)

\method{get_invalid}{default}(x, short_code = guess_short(x), ...)

\method{get_invalid}{icd9}(x, short_code = guess_short(x), ...)

\method{get_invalid}{icd10}(x, short_code = guess_short(x), ...)

\method{get_invalid}{comorbidity_map}(x, short_code = guess_short(x),
  ...)
}
\arguments{
\item{x}{vector of ICD codes, or list of vectors of ICD codes forming a
comorbidity map}
}
\description{
Returns subset of codes which are not in valid short_code or
  decimal format.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method when ICD version or short versus
decimal not known.

\item \code{icd9}: Get invalid ICD-9 codes from vector of codes

\item \code{icd10}: Get invalid ICD-10 codes from vector of codes

\item \code{comorbidity_map}: Get invalid elements of a comorbidity map
}}

\keyword{internal}
