% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9InReferenceCode}
\alias{"\%i9in\%"}
\alias{\%i9in\%}
\alias{icd9InReferenceCode}
\title{match ICD9 codes}
\usage{
icd9InReferenceCode(icd9, icd9Reference, short = TRUE,
  shortReference = TRUE, validate = FALSE, validateReference = FALSE)

icd9 \%i9in\% icd9Reference
}
\arguments{
\item{"icd9,icd9Reference"}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{short}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{validate}{logical whether to validate the input ICD-9 codes for
correctness. There may be additional simple checks, e.g. whether the code
is of the right type, regardless of this argument.}

\item{shortReference}{logical, see argument \code{short}}
}
\value{
logical vector of which icd9 match or are subcategory of
  icd9Referenec
}
\description{
This does the hard work of finding whether a given icd9 code
  falls under a group of reference ICD9 codes. icd9Reference is expanded to cover
  all possible subgroups, then we look for matches where the given ICD9 codes
  appear in the icd9Reference.
  http://www.acep.org/Clinical---Practice-Management/V-and-E-Codes-FAQ/
}
\examples{
"1024" \%i9in\% "102"
"1024" \%i9in\% c("102","1025")
c("102", "1024","1025") \%i9in\% "102"
c("102", "1024","1025") \%i9in\% c("1024", "1025")
c("102", "1024","1025") \%i9in\% c("102", "1024", "1025")
}
\seealso{
comorbidities.
}
\keyword{internal}

