# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname icd9Comorbid
#' @description RcppParallel approach to comorbidity assignment with OpenMP and vector of integers strategy. It is very
#'   fast, and most time is now spent setting up the data to be passed in.
#' @param aggregate single logical value, if /code{TRUE}, then take (possible much) more time to aggregate
#'   out-of-sequence visit IDs in the icd9df data.frame. If this is \code{FALSE}, then each contiguous group of visit
#'   IDs will result in a row of comorbidities in the output data. If you know your visitIds are possible disordered,
#'   then use \code{TRUE}.
#' @keywords internal
icd9ComorbidShortCpp <- function(icd9df, icd9Mapping, visitId, icd9Field, threads = 8L, chunkSize = 256L, ompChunkSize = 1L, aggregate = TRUE) {
    .Call('icd9_icd9ComorbidShortCpp', PACKAGE = 'icd9', icd9df, icd9Mapping, visitId, icd9Field, threads, chunkSize, ompChunkSize, aggregate)
}

icd9MajMinToCode <- function(major, minor, isShort) {
    .Call('icd9_icd9MajMinToCode', PACKAGE = 'icd9', major, minor, isShort)
}

icd9MajMinToShort <- function(major, minor) {
    .Call('icd9_icd9MajMinToShort', PACKAGE = 'icd9', major, minor)
}

icd9MajMinToDecimal <- function(major, minor) {
    .Call('icd9_icd9MajMinToDecimal', PACKAGE = 'icd9', major, minor)
}

#' @rdname convert
#' @keywords internal manip
icd9PartsToShort <- function(parts) {
    .Call('icd9_icd9PartsToShort', PACKAGE = 'icd9', parts)
}

#' @rdname convert
#' @keywords internal manip
icd9PartsToDecimal <- function(parts) {
    .Call('icd9_icd9PartsToDecimal', PACKAGE = 'icd9', parts)
}

icd9MajMinToParts <- function(major, minor) {
    .Call('icd9_icd9MajMinToParts', PACKAGE = 'icd9', major, minor)
}

icd9MajMinToParts_list <- function(major, minor) {
    .Call('icd9_icd9MajMinToParts_list', PACKAGE = 'icd9', major, minor)
}

#' @rdname convert
#' @keywords internal manip
icd9ShortToPartsCpp <- function(icd9Short, minorEmpty) {
    .Call('icd9_icd9ShortToPartsCpp', PACKAGE = 'icd9', icd9Short, minorEmpty)
}

#' @rdname convert
#' @keywords internal manip
icd9DecimalToPartsCpp <- function(icd9Decimal, minorEmpty) {
    .Call('icd9_icd9DecimalToPartsCpp', PACKAGE = 'icd9', icd9Decimal, minorEmpty)
}

#' @title Convert ICD-9 codes between short and decimal forms
#' @description Convert ICD-9 codes between short and decimal forms
#' @template icd9-short
#' @template icd9-decimal
#' @export
icd9ShortToDecimal <- function(icd9Short) {
    .Call('icd9_icd9ShortToDecimal', PACKAGE = 'icd9', icd9Short)
}

#' @rdname icd9ShortToDecimal
#' @export
icd9DecimalToShortOld <- function(icd9Decimal) {
    .Call('icd9_icd9DecimalToShortOld', PACKAGE = 'icd9', icd9Decimal)
}

#' @rdname convert
#' @export
icd9DecimalToShort <- function(icd9Decimal) {
    .Call('icd9_icd9DecimalToShort', PACKAGE = 'icd9', icd9Decimal)
}

#' @title Get major (three-digit) part of ICD-9 codes
#' @description This is reasonably fast, but calculates all the minors, then throws away the result.
#' @template icd9-any
#' @template isShort
#' @keywords internal manip
#' @export
icd9GetMajor <- function(icd9, isShort) {
    .Call('icd9_icd9GetMajor', PACKAGE = 'icd9', icd9, isShort)
}

#' @rdname icd9GetMajor
#' @keywords internal manip
icd9GetMajorShort <- function(icd9Short) {
    .Call('icd9_icd9GetMajorShort', PACKAGE = 'icd9', icd9Short)
}

#' @title test whether elements of vector begin with V, E (or any other
#'   character)
#' @description Current returns a std::vector<bool> which is not thread safe,
#'   or particularly fast, although it is memory efficient in the standard
#'   borked implementation. As of icd9 version 1.2, this is not called by
#'   threaded code, but this could change, so beware! ASCII spaces are trimmed
#'   from the start of the string before testing, but no other whitesapce
#' @param sv std::vector<std::string>&
#' @param x const char* of choices of first character to match
#' @keywords internal
icd9IsA <- function(sv, x, invert = FALSE) {
    .Call('icd9_icd9IsA', PACKAGE = 'icd9', sv, x, invert)
}

icd9LongToWideCpp <- function(icd9df, visitId, icd9Field, aggregate = TRUE) {
    .Call('icd9_icd9LongToWideCpp', PACKAGE = 'icd9', icd9df, visitId, icd9Field, aggregate)
}

icd9AddLeadingZeroesMajorSingle <- function(major) {
    .Call('icd9_icd9AddLeadingZeroesMajorSingle', PACKAGE = 'icd9', major)
}

icd9AddLeadingZeroesMajorSingleStd <- function(m) {
    .Call('icd9_icd9AddLeadingZeroesMajorSingleStd', PACKAGE = 'icd9', m)
}

icd9AddLeadingZeroesMajor <- function(major) {
    .Call('icd9_icd9AddLeadingZeroesMajor', PACKAGE = 'icd9', major)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesShort <- function(icd9Short) {
    .Call('icd9_icd9AddLeadingZeroesShort', PACKAGE = 'icd9', icd9Short)
}

#' @rdname icd9AddLeadingZeroes
icd9AddLeadingZeroesDecimal <- function(icd9Decimal) {
    .Call('icd9_icd9AddLeadingZeroesDecimal', PACKAGE = 'icd9', icd9Decimal)
}

#' @title Add leading zeroes to incomplete ICD codes
#' @description Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
#'   100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
#'   really 100
#' @template icd9-any
#' @template icd9-short
#' @template icd9-decimal
#' @template major
#' @return character vector of ICD codes (or major part thereof)
#' @keywords internal manip
icd9AddLeadingZeroes <- function(icd9, isShort) {
    .Call('icd9_icd9AddLeadingZeroes', PACKAGE = 'icd9', icd9, isShort)
}

icd9ExpandMinorShim <- function(minor, isE = FALSE) {
    .Call('icd9_icd9ExpandMinorShim', PACKAGE = 'icd9', minor, isE)
}

icd9ChildrenShortCpp <- function(icd9Short, onlyReal) {
    .Call('icd9_icd9ChildrenShortCpp', PACKAGE = 'icd9', icd9Short, onlyReal)
}

icd9ChildrenDecimalCpp <- function(icd9Decimal, onlyReal) {
    .Call('icd9_icd9ChildrenDecimalCpp', PACKAGE = 'icd9', icd9Decimal, onlyReal)
}

icd9ChildrenCpp <- function(icd9, isShort, onlyReal = TRUE) {
    .Call('icd9_icd9ChildrenCpp', PACKAGE = 'icd9', icd9, isShort, onlyReal)
}

#' @title match ICD9 codes
#' @description Finds children of \code{icd9Reference} and looks for \code{icd9} in the
#'   resulting vector.
#' @templateVar icd9AnyName "icd9,icd9Reference"
#' @template icd9-any
#' @template isShort
#' @param isShortReference logical, see argument \code{isShort}
#' @return logical vector
#' @keywords internal
icd9InReferenceCode <- function(icd9, icd9Reference, isShort, isShortReference = TRUE) {
    .Call('icd9_icd9InReferenceCode', PACKAGE = 'icd9', icd9, icd9Reference, isShort, isShortReference)
}

trimLeftCpp <- function(s) {
    .Call('icd9_trimLeftCpp', PACKAGE = 'icd9', s)
}

strimCpp <- function(s) {
    .Call('icd9_strimCpp', PACKAGE = 'icd9', s)
}

trimCpp <- function(sv) {
    .Call('icd9_trimCpp', PACKAGE = 'icd9', sv)
}

assertFactorOrCharacter <- function(x) {
    .Call('icd9_assertFactorOrCharacter', PACKAGE = 'icd9', x)
}

getOmpCores <- function() {
    .Call('icd9_getOmpCores', PACKAGE = 'icd9')
}

getOmpMaxThreads <- function() {
    .Call('icd9_getOmpMaxThreads', PACKAGE = 'icd9')
}

getOmpThreads <- function() {
    .Call('icd9_getOmpThreads', PACKAGE = 'icd9')
}

randomMajorCpp <- function(n) {
    .Call('icd9_randomMajorCpp', PACKAGE = 'icd9', n)
}

icd9RandomShortN <- function(n = 5L) {
    .Call('icd9_icd9RandomShortN', PACKAGE = 'icd9', n)
}

icd9RandomShortV <- function(n = 5L) {
    .Call('icd9_icd9RandomShortV', PACKAGE = 'icd9', n)
}

icd9RandomShortE <- function(n = 5L) {
    .Call('icd9_icd9RandomShortE', PACKAGE = 'icd9', n)
}

#' @title generate random short-form icd9 E codes
#' @description Very dirty pseudorandom by picking numeric, V or E based on modulo 3 of the number
#' @keywords internal
icd9RandomShort <- function(n = 5L) {
    .Call('icd9_icd9RandomShort', PACKAGE = 'icd9', n)
}

#' @rdname fastIntToString
#' @title fast convert integer vector to character vector
#' @description fast convert integer vector to character vector
#' @param x td::vector<int>
#' @param bufferSize int if any input strings are longer than this number (default 16) there will be memory errors.
#'   No checks done for speed.
#' @examples
#' \dontrun{
#' pts <- randomPatients(1e7)
#' # conclusion: buffer size matters little (so default to be more generous), and Rcpp version fastest.
#' microbenchmark::microbenchmark(fastIntToStringStd(pts$visitId, buffer = 8),
#'                                fastIntToStringStd(pts$visitId, buffer = 16),
#'                                fastIntToStringStd(pts$visitId, buffer = 64),
#'                                fastIntToStringRcpp(pts$visitId, buffer = 8),
#'                                fastIntToStringRcpp(pts$visitId, buffer = 16),
#'                                fastIntToStringRcpp(pts$visitId, buffer = 64),
#'                                as.character(pts$visitId),
#'                                asCharacterNoWarn(pts$visitId), times = 5)
#' }
#' @keywords internal
fastIntToStringStd <- function(x) {
    .Call('icd9_fastIntToStringStd', PACKAGE = 'icd9', x)
}

#' @rdname fastIntToString
fastIntToStringRcpp <- function(x) {
    .Call('icd9_fastIntToStringRcpp', PACKAGE = 'icd9', x)
}

callgrindStart <- function(zerostats = FALSE) {
    .Call('icd9_callgrindStart', PACKAGE = 'icd9', zerostats)
}

valgrindCallgrindStart <- function(zerostats = FALSE) {
    .Call('icd9_valgrindCallgrindStart', PACKAGE = 'icd9', zerostats)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('icd9_RcppExport_registerCCallable', PACKAGE = 'icd9')
})
