% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{icd9ComorbidDfToMat}
\alias{icd9ComorbidDfToMat}
\title{convert matrix of comorbidities into data frame, preserving visitId
  information}
\usage{
icd9ComorbidDfToMat(x, visitId = NULL,
  stringsAsFactors = getOption("stringsAsFactors"))
}
\arguments{
\item{x}{data frame, with a \code{visitId} column (not necessarily first),
and other columns with flags for comorbidities, as such column names are
required.}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visitId}
was not specified, then the first column of the data frame is used.}

\item{stringsAsFactors}{whether the resulting data frame should have strings,
i.e. visitId converted to factor. Default is to follow the current session
option.}
}
\description{
convert matrix of comorbidities into data frame, preserving visitId
  information
}
\examples{
longdf <- data.frame(visitId = c("a", "b", "b", "c"),
    icd9 = c("441", "4424", "443", "441"))
cmbdf <- icd9ComorbidElix(longdf, return.df = TRUE)
class(cmbdf)
rownames(cmbdf)
mat.out <- icd9ComorbidDfToMat(cmbdf)
stopifnot(is.matrix(mat.out))
mat.out[, 1:4]
}

