% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummaryTable.R
\name{getSummaryTable}
\alias{getSummaryTable}
\title{Get a Summary Table of Historical Stock Size}
\usage{
getSummaryTable(key)
}
\arguments{
\item{key}{the unique identifier of the stock assessment}
}
\value{
A data frame.
}
\description{
Get summary results of historical stock size, recruitment, and fishing
pressure.
}
\examples{
stocklist <- getListStocks(2016)
id <- grep("cod-2224", stocklist$FishStockName)
stocklist[id,]
key <- stocklist$AssessmentKey[id]
sumtab <- getSummaryTable(key)
head(sumtab)
attributes(sumtab)$notes

}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getFishStockReferencePoints}} get
  a list of stocks and reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar and Scott Large.
}
