% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSAGGraphs.R
\name{getSAGGraphs}
\alias{getSAGGraphs}
\title{Get Summary Graphs of Stock Assessment Output}
\usage{
getSAGGraphs(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{to allow scope for back compatability}
}
\value{
An array representing a bitmap.
}
\description{
Get summary graphs of catches, recruitment, fishing pressure, and spawning
stock biomass.
}
\examples{
assessmentKey <- findAssessmentKey("cod", 2015)
graphs <- getSAGGraphs(assessmentKey[1])
plot(graphs)

}
\seealso{
\code{\link{getListStocks}} gets a list of stocks.

\code{\link{getFishStockReferencePoints}} gets biological reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar and Scott Large.
}
