% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.taf.R
\name{read.taf}
\alias{read.taf}
\title{Read TAF Table from File}
\usage{
read.taf(file, check.names = FALSE, fileEncoding = "UTF-8", ...)
}
\arguments{
\item{file}{a filename.}

\item{check.names}{whether to enforce regular column names, e.g. convert
column name \samp{3} to \samp{X3}.}

\item{fileEncoding}{character encoding of input file.}

\item{\dots}{passed to \code{read.csv}.}
}
\value{
A data frame in TAF format.
}
\description{
Read a TAF table from a file into a data frame.
}
\examples{
\dontrun{
write.taf(catage.taf, "catage.csv")
catage <- read.taf("catage.csv")

file.remove("catage.csv")
}

}
\seealso{
\code{\link{read.csv}} is the underlying function used to read a table from a
file.

\code{\link{write.taf}} writes a TAF table to a file.

\code{\link{icesTAF-package}} gives an overview of the package.
}
