% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.software.R
\name{draft.software}
\alias{draft.software}
\title{Draft SOFTWARE.bib}
\usage{
draft.software(package, author = NULL, year = NULL, title = NULL,
  version = NULL, source = NULL, file = "", append = FALSE)
}
\arguments{
\item{package}{name of one or more R packages, or files/folders inside
\verb{bootstrap/initial/software}.}

\item{author}{author(s) of the software.}

\item{year}{year when this version of the software was released, or the
publication year of the cited manual/article/etc.}

\item{title}{title or short description of the software.}

\item{version}{string to specify details about the version, e.g. GitHub
branch and commit date.}

\item{source}{string to specify where the software are copied/downloaded
from. This can be a GitHub reference of the form
\verb{owner/repo[/subdir]@ref}, URL, or a filename.}

\item{file}{optional filename to save the draft metadata to a file. The value
\code{TRUE} can be used as shorthand for
\code{"bootstrap/SOFTWARE.bib"}.}

\item{append}{whether to append metadata entries to an existing file.}
}
\value{
Object of class \verb{Bibtex}.
}
\description{
Create an initial draft version of a \file{SOFTWARE.bib} metadata file.
}
\details{
Typical usage is to specify \code{package}, while using the default values
for the other arguments.

If \code{package} is an R package, it can either be a package that is already
installed (\code{"icesAdvice"}) or a GitHub reference
(\code{"ices-tools-prod/icesAdvice@4271797"}).

With the default \verb{version = NULL}, the function will automatically
suggest an appropriate version entry for CRAN packages, but for GitHub
packages it is left to the user to add further information about the GitHub
branch (if different from \verb{master}) and the commit date.

With the default \verb{source = NULL}, the function will automatically
suggest an appropriate source entry for CRAN and GitHub packages, but for
other R packages it is left to the user to add information about where the
software can be accessed.

The default value \code{file = ""} prints the initial draft in the console,
instead of writing it to a file. The output can then be pasted into a file to
edit further, without accidentally overwriting an existing metadata file.
}
\note{
After creating the initial draft, the user can complete the \verb{version},
\verb{source}, and other fields as required.

This function is especially useful for citing exact versions of R packages on
GitHub. To prepare metadata for software other than R packages, see the
\code{\link{process.bib}} help page for an example.
}
\examples{
\donttest{
# Print in console
draft.software("icesTAF")
}

\dontrun{
# Export to file
draft.software("icesTAF", file=TRUE)
}

}
\seealso{
\code{\link{citation}} and \code{\link{packageDescription}} are the
underlying functions to access information about installed R packages.

\code{\link{draft.data}} creates an initial draft version of a
\verb{DATA.bib} metadata file.

\code{\link{process.bib}} reads and processes metadata entries.

\code{\link{icesTAF-package}} gives an overview of the package.
}
