% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wgfbit_data2.R
\name{get_wgfbit_data2}
\alias{get_wgfbit_data2}
\title{Download swept area ratio, landings and value map data}
\usage{
get_wgfbit_data2(ecoregion, year, convert2sf = FALSE)
}
\arguments{
\item{ecoregion}{ICES ecoregion}

\item{year}{which year to select}

\item{convert2sf}{logical, default FALSE, should an simple features object
be returned if the \code{sf} package is installed?}
}
\value{
a data.frame with a WKT column for the c-square polygons
}
\description{
Download a data.frame of surface and subsurface swept area
ratio by c-square for a given ICES ecoregion, year and gear code.
}
\examples{
\dontrun{
# requires authorization
data2 <- get_wgfbit_data2("Celtic Seas", 2021, convert2sf = TRUE)
plot(data2[data2$lE_MET_level6 == "OTB_DEF_70-99_0_0", "total_weight"], border = NA, logz = TRUE)
}

}
