% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{grid_dup}
\alias{grid_dup}
\title{Duplicates of expand.grid for 2 Variables}
\usage{
grid_dup(n, omit.id)
}
\arguments{
\item{n}{the length of vector passed to \code{expand.grid()}.}

\item{omit.id}{(optional) set to TRUE to also select the elements where the 2
items are identical. The output of expand.grid, subset to remove
duplicates with 'omit.id' set to TRUE would be the equivalent of
\code{utils::combn(n, 2)}.}
}
\value{
A numeric vector.
}
\description{
Create a vector of element positions of duplicates in the output of expand.grid
    on 2 identical vectors. A faster method of creating combinations for 2
    variabes than \code{utils::combn()}.
}
\keyword{internal}
