% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{getPrices}
\alias{getPrices}
\title{getPrices}
\usage{
getPrices(
  instrument,
  granularity,
  count,
  from,
  to,
  price,
  server,
  apikey,
  .validate
)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by a '_' (for example "USD_JPY").}

\item{granularity}{the granularity of the price data to fetch,
one of "M", "W", "D", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30",
"M15", "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5".}

\item{count}{(optional) the number of periods to return. The API supports a
maximum of 5000 for each individual request, and defaults to 500 if not
specified.}

\item{from}{(optional) the start of the time range for which to fetch price
data, for example "2020-02-01".}

\item{to}{(optional) the end of the time range for which to fetch price data,
for example "2020-06-30".}

\item{price}{pricing component, one of "M" (midpoint), "B" (bid)
or "A" (ask).}

\item{server}{select either the "practice" or "live" server
depending on the account type held with OANDA.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string.}

\item{.validate}{(optional) only used internally by other functions. Do not
set this parameter.}
}
\value{
A data.frame containing the price data requested.
}
\description{
Internal function used by ichimoku to retrieve price candles from the OANDA
    fxTrade REST API.
}
\keyword{internal}
