% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_stream}
\alias{oanda_stream}
\title{OANDA Streaming Data}
\usage{
oanda_stream(instrument, server, apikey)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by '_' or '-' (e.g. "USD_JPY" or "usd-jpy"). Use the
\code{\link{oanda_instruments}} function to return a list of all valid
instruments.}

\item{server}{(optional) specify the "practice" or "live" server according to
the account type held. If not specified, will default to "practice", unless
this has been changed by \code{\link{oanda_switch}}.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
Invisible NULL on function exit. The streaming data is output as text
    to the console.
}
\description{
Stream live price and liquidity data for major currencies, metals,
    commodities, government bonds and stock indices from the OANDA fxTrade
    Streaming API.
}
\details{
This function connects to the OANDA fxTrade Streaming API. Use the
    'Esc' key to stop the stream.

    The output contains ANSI escape codes for console formatting, but
    otherwise represents the raw feed without omission. Note that as this is
    a raw stream, returned times are in UTC.
}
\section{Streaming Data}{


    Get a stream of Account Prices starting from when the request is made.
    This pricing stream does not include every single price created for the
    Account, but instead will provide at most 4 prices per second (every
    250 milliseconds) for each instrument being requested. If more than one
    price is created for an instrument during the 250 millisecond window,
    only the price in effect at the end of the window is sent. This means
    that during periods of rapid price movement, subscribers to this stream
    will not be sent every price. Pricing windows for different connections
    to the price stream are not all aligned in the same way (i.e. they are
    not all aligned to the top of the second). This means that during
    periods of rapid price movement, different subscribers may observe
    different prices depending on their alignment.
}

\section{Further Details}{

    Please refer to the OANDA fxTrade API vignette by calling:
    \code{vignette("xoanda", package = "ichimoku")}.
}

\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
oanda_stream("USD_JPY")
}

}
