% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ichimoku}
\alias{plot.ichimoku}
\title{Plot Ichimoku Cloud Chart}
\usage{
\method{plot}{ichimoku}(
  x,
  window,
  ticker,
  subtitle,
  theme = c("original", "dark", "solarized", "mono"),
  strat = TRUE,
  type = c("none", "r", "s", "bar", "line"),
  custom,
  ...
)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{window}{(optional) a date-time window to subset the plot, in ISO-8601
compatible range strings of the format used for 'xts' objects, for example
"2020-02-15/2020-08-15" or "2020-02-15/", "/2020-08" or "2020-07".}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{subtitle}{(optional) specify a subtitle to display under the chart title.}

\item{theme}{[default 'original'] with alternative choices of 'dark',
'solarized' or 'mono'.}

\item{strat}{[default TRUE] if the ichimoku object contains a strategy, the
periods for which the strategy results in a position will be shaded, and
the strategy printed as the chart subtitle (if not otherwise specified).
Set to FALSE to turn off this behaviour.}

\item{type}{[default 'none'] type of sub-plot to display beneath the ichimoku
cloud chart, with a choice of 'none', 'r' or 's' for the corresponding
oscillator type, and 'bar' or 'line' for custom plots.}

\item{custom}{(optional) character string (containing a regular expression)
matching the column name of the variable to be displayed as sub-plot.
Specify \code{type = 'bar'} or \code{type = 'line'}, otherwise other type
settings will take precedence.}

\item{...}{additional arguments passed along to the print method for 'ggplot'
objects when \code{type = 'none'}.}
}
\value{
The ichimoku object supplied (invisibly). The requested plot is output
    to the graphical device.
}
\description{
Plot Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\details{
This function is an S3 method for the generic function plot() for
    class 'ichimoku'. It can be invoked by calling plot(x) on an object 'x'
    of class 'ichimoku'.

    For further details please refer to the reference vignette by calling:
    \code{vignette("reference", package = "ichimoku")}
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

plot(cloud)
plot(cloud, window = "2020-05-01/2020-12-01", theme = "dark")
plot(cloud, window = "2020-05/", ticker = "TKR Co.", theme = "solarized", type = "s")
plot(cloud, window = "/2020-11-02", subtitle = "Sample Price Data", theme = "mono", type = "r")

kumo <- ichimoku(sample_ohlc_data, ticker = "TKR", keep.data = TRUE)

plot(kumo, theme = "solarized", type = "bar", custom = "volume")
plot(kumo, theme = "original", type = "line", custom = "volume")

}
