% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-attributes.R
\name{edgelength}
\alias{edgelength}
\alias{edgelength,trigrid-method}
\title{Lengths of grid edges}
\usage{
edgelength(gridObj, ...)

\S4method{edgelength}{trigrid}(gridObj, output = "distance")
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}} or \code{{hexagrid}}) A grid object.}

\item{...}{Arguments passed to the class specific methods.}

\item{output}{(\code{character}) The type of the output. \code{"distance"} will give back the distance
in the metric that was fed to the function in the coordinates or the radius.
\code{"deg"} will output the the distance in degrees, \code{"rad"} will do
so in radians.}
}
\value{
A named \code{numeric} vector.
}
\description{
This function will return the length of all edges in the specified grid object.
}
\examples{
g <- trigrid(3)
edges <- edgelength(g, output="deg")
edges

}
