% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{heatMapLegend}
\alias{heatMapLegend}
\title{Legend for a heatmap with predefined colors.}
\usage{
heatMapLegend(cols, minVal, varName, tick.text, maxVal, ticks = 5,
  tick.cex = 1.5, barWidth = 3, barHeight = 50, tickLength = 1,
  xLeft = 88, yBot = 25, add = FALSE, ...)
}
\arguments{
\item{cols}{Character vector, containnig the ordered colors that are used for the heatmap.}

\item{minVal}{If tick.text is missing, the lowest value in the heatmap}

\item{varName}{The label of the variable name plotted to the heatmap.}

\item{tick.text}{The values on the heatmap legend. If missing, will be calculated with minVal and maxVal. Should have the length as 'ticks'.}

\item{maxVal}{If tick.text is missing, the highest value in the heatmap}

\item{ticks}{The number of ticks/values in the heatmap legend (the bar will be divided to this number).}

\item{tick.cex}{Letter size of the values on the legend.}

\item{barWidth}{The width (percent) of the bar featuring the colors of the heatmap.}

\item{barHeight}{The height (percent)of the bar featuring the colors of the heatmap.}

\item{tickLength}{The length (percent) of the ticks at the bars.}

\item{xLeft}{the x coordinate of the lower left hand corner of the bar.}

\item{yBot}{the y coordinate of the lower left hand corner of the bar.}

\item{add}{indicates wheter a new plot should be drawn or not. Defaults to FALSE.}

\item{...}{arguments passed to the plot() function.}
}
\description{
This function will invoke the plot function to draw a heatmap legend.
}
\details{
The 'percents' refer to the plotting area measured from the lower left corner.
}

