% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/application.R
\name{occupied}
\alias{occupied}
\title{Faces occupied by the specified object}
\usage{
occupied(gridObj, data, ...)
}
\arguments{
\item{gridObj}{a \code{trigrid} or \code{hexagrid} object.}

\item{data}{the queried data.}

\item{...}{arguments passed to the class specific methods}
}
\value{
returns a facelayer object
}
\description{
This function will return a \code{facelayer} class object showing which faces are occupied by the input object.
}
\details{
This is a wrapper function on the \code{OccupiedFaces} methods that are specific to grid class and input data. The function creates a link between the facelayer and the relevant grid.
}
\examples{
# create a grid
g <- trigrid(8, sp=TRUE)
# create random points
randPoints <- rpsphere(100,output="polar")
# the facelayer occupied by these points
randomLayer <- occupied(g, randPoints)
plot(randomLayer)
points(randPoints, col="blue", pch="+")


}

