% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.r, R/layers.R
\docType{methods}
\name{subset,trigrid-method}
\alias{[,gridlayer,ANY,missing-method}
\alias{[,gridlayer,Extent,missing-method}
\alias{[,trigrid,ANY,ANY-method}
\alias{[-gridlayer-Extent-method}
\alias{[-gridlayer-index-method}
\alias{[-trigrid-method}
\alias{subset,}
\alias{subset,gridlayer-method}
\alias{subset,hexagrid-method}
\alias{subset,trigrid-method}
\alias{subset-gridlayer-method}
\alias{subset-hexagrid-method}
\alias{subset-trigrid-method}
\title{Subsetting an icosahedral grid}
\usage{
\S4method{subset}{trigrid}(x, i)

\S4method{subset}{hexagrid}(x, i)

\S4method{[}{trigrid,ANY,ANY}(x, i)

\S4method{subset}{gridlayer}(x, subsetVector)

\S4method{[}{gridlayer,ANY,missing}(x, i)

\S4method{[}{gridlayer,Extent,missing}(x, i)
}
\arguments{
\item{x}{The gridlayer object to be subsetted.}

\item{i}{A subscript vector, specifying the names of the face that are used for subsetting.}

\item{subsetVector}{Vector object indicating the faces to be subsetted.}
}
\value{
Subset of the input grid. The class of the original object is retained, the \code{@skeleton} slot contains all previous information.
}
\description{
This is a generic function used to access data from either a triangular or hexagonal grid using the names of the faces, integers or logical vectors.

Shorthand for the subset function.

The function extracts parts of the gridlayer depending on different criteria.

Shorthand to the subset() function.

Shorthand to the subset() function.
}
\details{
The function returns subsets of the grid pertaining to the specified faces that can be used for additional operations (e.g. plotting). 
The subscript vector can be either a logical, character or numeric one. The character vector should contain the names of faces, the logical subscript should have 
the same length as the number of faces in the order in which the faces are present in the \code{faces} slot. 
The numeric vector can either refer to indices to the rownames of faces in the faces slot, or
to surfaces bounded by longitude/latitude data. In the latter case, the the vector should contain an element with a names of at least one of the "lomax", "lamax", 
"lomin" or "lamin" strings (lo for longitude, la: latitude, min: minimum, max: maximum). In case a subset around the dateline is needed a larger longitude to a smaller longitude value is needed (e.g. between 150° to -150°).

The following methods are incorporated into the function. If the subsetVector argument is a vector of integers, they will be interpreted as indices. If the numeric subsetVector contains either the lamin, lamax, lomin or lomax names, the subsetting will be done using the latitude-longitude coordinates outlined by these 4 values. Logical subsetting and subsetting by face names are also possible.
}
\examples{
    #create a triangular grid
        g <- trigrid(c(2,2))
    #make a subset pertaining to the faces
        subG1 <- subset(g, c("F1", "F33"))
    
   #additional way of subsetting
		subG2 <- g[1:15] # selects faces F1 through F15
    logicalSub<-sample(c(TRUE,FALSE), nrow(g@faces), replace=TRUE)
		subG3 <- g[logicalSub]
    #plot the subset in 3d space
        plot3d(subG3)
	# previously mentioned case around the dateline
	gDateLine<-g[c(lomax=-150, lomin=150)]
		plot3d(gDateLine)

}

