% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math-volume.R
\name{burn_volume}
\alias{burn_volume}
\title{Burn image at given positions}
\usage{
burn_volume(
  image,
  ras_position,
  col = "red",
  radius = 1,
  reshape = FALSE,
  alpha = FALSE,
  blank_underlay = FALSE,
  ...,
  preview = NULL
)
}
\arguments{
\item{image}{volume}

\item{ras_position}{image-defined right-anterior-posterior positions, an
\code{nx3} matrix, each row is an 'RAS' coordinate}

\item{col}{vector of integer or characters, color of each contact}

\item{radius}{vector of positive number indicating the burning radius}

\item{reshape}{whether to reshape the image at a different resolution;
default is false; can be \code{TRUE} (image resolution will be doubled),
a single number (size of isotropic volume along one side), or
a length of three defining the new shape.}

\item{alpha}{whether to include alpha (transparent) channel. Default is
false for compatibility concerns (legacy software might not support
reading alpha channel). In this case, the background will be black.
If \code{alpha=TRUE} is set, then the background will be fully transparent.}

\item{blank_underlay}{whether to use blank image or the input
\code{image} as underlay; default is \code{FALSE} (using \code{image}
as underlay); alternative is \code{TRUE}, and use black or transparent
background}

\item{...}{passed to \code{\link{as_ieegio_volume}}, useful if \code{image}
is an array}

\item{preview}{indices (integer) of the position to visualize; default is
\code{NULL} (no preview)}
}
\value{
Color image that is burnt; see \code{\link{imaging-volume}}.
}
\description{
Burn image at given positions with given color and radius.
}
\examples{

if(interactive()) {

dim <- c(6, 6, 6)
image <- as_ieegio_volume(
  array(rnorm(prod(dim)), dim),
  vox2ras = rbind(cbind(diag(1, 3), -dim / 2),
                  c(0, 0, 0, 1))
)

ras_positions <- rbind(c(1, -1, 1.5), c(-2.25, -1, -0.75))


burned <- burn_volume(
  image,
  ras_positions,
  col = c("red", "green"),
  radius = 0.5,
  reshape = c(24, 24, 24)
)

plot(
  burned,
  position = ras_positions[1, ],
  zoom = 15,
  pixel_width = 0.25
)

}
}
