% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpIntPaid.R
\encoding{UTF-8}
\name{SimpIntPaid}
\alias{SimpIntPaid}
\title{Simple Interest Paid (Engineering Economics)}
\usage{
SimpIntPaid(P, n, i)
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as whole number
or decimal}
}
\value{
SimpIntPaid numeric vector that contains the total amount paid at
   the end of n periods rounded to 2 decimal places
}
\description{
Computes the total amount paid at the end of n periods using simple interest
}
\details{
Simple Interest is expressed as

\deqn{I = Pni}

\deqn{S_n = P + I}

or

\deqn{S_n = P\left(1 + ni\right)}

\describe{
\item{\emph{P}}{the "principal amount (lent or borrowed)"}
\item{\emph{\eqn{S_n}}}{the "total amount paid back"}
\item{\emph{I}}{the "simple interest"}
\item{\emph{i}}{the "interest rate per interest period"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{
library("iemisc")
# Example for equation 4-1 from the Sullivan Reference text (page 116)
SimpIntPaid(1000, 3, 10) # the interest rate is 10\%




}
\references{
\enumerate{
\item Chinyere Onwubiko, \emph{An Introduction to Engineering}, Mission, Kansas: Schroff Development Corporation, 1997, page 205-206.
\item William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 116.
}
}
