% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engr_survey2.R
\encoding{UTF-8}
\name{engr_survey2}
\alias{engr_survey2}
\title{Calculate the Distance between Engineering Survey Points}
\usage{
engr_survey2(
  station1,
  station2,
  station_distance = 100,
  units1 = c("foot", "survey_ft", "meters", "kilometers"),
  units2 = c("foot", "survey_ft", "survey_mile", "mile", "meters", "kilometers")
)
}
\arguments{
\item{station1}{character vector that contains the begin engineering
survey station value}

\item{station2}{character vector that contains the end engineering
survey station value}

\item{station_distance}{numeric vector that contains the horizontal distance
between any 2 points along the survey, the default is 100 feet}

\item{units1}{character vector that contains the system of units for the
\code{station_distance} (options are \code{foot}, \code{survey_ft}
(United States Customary System) [US survey foot], \code{meters} for
International System of Units meters, or \code{kilometers} for International System
of Units kilometers}

\item{units2}{character vector that contains the system of units for the
horizontal length (options are \code{foot}, \code{survey_ft}
(United States Customary System) [US survey foot], \code{survey_mile}
(United States Customary System) [US survey mile], \code{mile},
\code{meters} for International System of Units meters, or \code{kilometers} for
International System of Units kilometers}
}
\value{
the calculated horizontal distance in the chosen unit as a numeric
    vector with the units attached
}
\description{
Takes engineering survey points in various units (foot, US survey foot,
meters, or kilometers) and calculates the horizontal length in various units
(foot, US survey foot, US survey mile, mile, meters, or kilometers).
}
\examples{

# Please refer to the iemisc: Engineering Survey Examples vignette for
# additional examples

# Example 1

library("iemisc")

engr_survey2("395+75", "397+13", station_distance = 100, units1 = "foot",
units2 = "foot")



# Example 2

library("iemisc")

station1 <- "333+03"
station2 <- "332+94"

engr_survey2(station1, station2, units1 = "foot", units2 = "survey_mile")



# Example 3 from Lewis Reference document page 25

library("iemisc")

station3 <- "10+25.62"
station4 <- "189+45.72"

engr_survey2(station3, station4, units1 = "foot", units2 = "mile")



# Example 4 from Georgia reference page 27 (document page 43)

library("iemisc")

engr_survey2("701+50.00", "409+69.00", station_distance = 100,
units1 = "survey_ft", units2 = "foot")






}
\references{
\enumerate{
   \item udunits.dat, v 1.18 2006/09/20 18:59:18 steve Exp, \url{https://web.archive.org/web/20230202155021/https://www.unidata.ucar.edu/software/udunits/udunits-1/udunits.txt}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item Ben W. Lewis, PE, July 12, 2016, "Construction Plan Reading Basics & Applications Part III Typical Calculations / Quantity Take-off's: Calculate Project Length", \url{http://www.richlandonline.com/Portals/0/Departments/Procurement/SLBE/Plan\%20Reading\%20PowerPoint\%20Presentation.pdf}.
   \item Georgia Department of Transportation Skills Development Series, Revised May 1, 2008, "Basic Highway Plan Reading", \url{https://www.dot.ga.gov/PartnerSmart/Training/Documents/ESD/BasicHiwyPlanReading.pdf}.
}
}
\author{
Irucka Embry
}
