# Interest rates used in Engineering Economics

library(data.table)

options(scipen = 999) # Source 1

# Discrete
n <- c(1:25, seq(30, 50, by = 5), seq(60, 100, by = 20))
ni <- Inf
niu1 <- 10000 # less than 8%
niu2 <- 1000 # 8% and greater
nisu1 <- c(n, niu1)
nisu2 <- c(n, niu2)
nis <- c(n, ni)
i <- c(0.25, 0.50, 0.75, 1, 1.5, 2:10, 12, 15, 18, 20, 25)
iuse <- i / 100

columns <- c("n", "F/P", "P/F", "F/A", "P/A", "A/F", "A/P", "P/G", "A/G", "n")

# interest of 0.25%
F_P <- ((1 + iuse[1]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[1])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[1]) ^ n - 1) / iuse[1])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[1]) ^ nisu1 - 1) / (iuse[1] * ((1 + iuse[1]) ^ nisu1)))
A_F <- (iuse[1] / (((1 + iuse[1]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[1] * ((1 + iuse[1]) ^ nisu1)) / (((1 + iuse[1]) ^ nisu1) - 1))
P_G <- (1 / iuse[1]) * (((((1 + iuse[1]) ^ n) - 1) / (iuse[1] * ((1 + iuse[1]) ^ n))) - (n / (1 + iuse[1]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[1]) - (n / (((1 + iuse[1]) ^ n) - 1)))
A_G <- c(A_G, NA)
i_25 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i_25 <- round(i_25, digits = 6)
setnames(i_25, columns)
save(i_25, file = "./data/i_25.rda")


# interest of 0.50%
F_P <- ((1 + iuse[2]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[2])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[2]) ^ n - 1) / iuse[2])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[2]) ^ nisu1 - 1) / (iuse[2] * ((1 + iuse[2]) ^ nisu1)))
A_F <- (iuse[2] / (((1 + iuse[2]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[2] * ((1 + iuse[2]) ^ nisu1)) / (((1 + iuse[2]) ^ nisu1) - 1))
P_G <- (1 / iuse[2]) * (((((1 + iuse[2]) ^ n) - 1) / (iuse[2] * ((1 + iuse[2]) ^ n))) - (n / (1 + iuse[2]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[2]) - (n / (((1 + iuse[2]) ^ n) - 1)))
A_G <- c(A_G, NA)
i_50 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i_50 <- round(i_50, digits = 6)
setnames(i_50, columns)
save(i_50, file = "./data/i_50.rda")


# interest of 0.75%
F_P <- ((1 + iuse[3]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[3])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[3]) ^ n - 1) / iuse[3])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[3]) ^ nisu1 - 1) / (iuse[3] * ((1 + iuse[3]) ^ nisu1)))
A_F <- (iuse[3] / (((1 + iuse[3]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[3] * ((1 + iuse[3]) ^ nisu1)) / (((1 + iuse[3]) ^ nisu1) - 1))
P_G <- (1 / iuse[3]) * (((((1 + iuse[3]) ^ n) - 1) / (iuse[3] * ((1 + iuse[3]) ^ n))) - (n / (1 + iuse[3]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[3]) - (n / (((1 + iuse[3]) ^ n) - 1)))
A_G <- c(A_G, NA)
i_75 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i_75 <- round(i_75, digits = 6)
setnames(i_75, columns)
save(i_75, file = "./data/i_75.rda")


# interest of 1.00%
F_P <- ((1 + iuse[4]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[4])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[4]) ^ n - 1) / iuse[4])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[4]) ^ nisu1 - 1) / (iuse[4] * ((1 + iuse[4]) ^ nisu1)))
A_F <- (iuse[4] / (((1 + iuse[4]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[4] * ((1 + iuse[4]) ^ nisu1)) / (((1 + iuse[4]) ^ nisu1) - 1))
P_G <- (1 / iuse[4]) * (((((1 + iuse[4]) ^ n) - 1) / (iuse[4] * ((1 + iuse[4]) ^ n))) - (n / (1 + iuse[4]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[4]) - (n / (((1 + iuse[4]) ^ n) - 1)))
A_G <- c(A_G, NA)
i1 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i1 <- round(i1, digits = 6)
setnames(i1, columns)
save(i1, file = "./data/i1.rda")


# interest of 1.50%
F_P <- ((1 + iuse[5]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[5])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[5]) ^ n - 1) / iuse[5])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[5]) ^ nisu1 - 1) / (iuse[5] * ((1 + iuse[5]) ^ nisu1)))
A_F <- (iuse[5] / (((1 + iuse[5]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[5] * ((1 + iuse[5]) ^ nisu1)) / (((1 + iuse[5]) ^ nisu1) - 1))
P_G <- (1 / iuse[5]) * (((((1 + iuse[5]) ^ n) - 1) / (iuse[5] * ((1 + iuse[5]) ^ n))) - (n / (1 + iuse[5]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[5]) - (n / (((1 + iuse[5]) ^ n) - 1)))
A_G <- c(A_G, NA)
i1_50 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i1_50 <- round(i1_50, digits = 6)
setnames(i1_50, columns)
save(i1_50, file = "./data/i1_50.rda")


# interest of 2.00%
F_P <- ((1 + iuse[6]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[6])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[6]) ^ n - 1) / iuse[6])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[6]) ^ nisu1 - 1) / (iuse[6] * ((1 + iuse[6]) ^ nisu1)))
A_F <- (iuse[6] / (((1 + iuse[6]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[6] * ((1 + iuse[6]) ^ nisu1)) / (((1 + iuse[6]) ^ nisu1) - 1))
P_G <- (1 / iuse[6]) * (((((1 + iuse[6]) ^ n) - 1) / (iuse[6] * ((1 + iuse[6]) ^ n))) - (n / (1 + iuse[6]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[6]) - (n / (((1 + iuse[6]) ^ n) - 1)))
A_G <- c(A_G, NA)
i2 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i2 <- round(i2, digits = 6)
setnames(i2, columns)
save(i2, file = "./data/i2.rda")


# interest of 3.00%
F_P <- ((1 + iuse[7]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[7])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[7]) ^ n - 1) / iuse[7])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[7]) ^ nisu1 - 1) / (iuse[7] * ((1 + iuse[7]) ^ nisu1)))
A_F <- (iuse[7] / (((1 + iuse[7]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[7] * ((1 + iuse[7]) ^ nisu1)) / (((1 + iuse[7]) ^ nisu1) - 1))
P_G <- (1 / iuse[7]) * (((((1 + iuse[7]) ^ n) - 1) / (iuse[7] * ((1 + iuse[7]) ^ n))) - (n / (1 + iuse[7]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[7]) - (n / (((1 + iuse[7]) ^ n) - 1)))
A_G <- c(A_G, NA)
i3 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i3 <- round(i3, digits = 6)
setnames(i3, columns)
save(i3, file = "./data/i3.rda")


# interest of 4.00%
F_P <- ((1 + iuse[8]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[8])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[8]) ^ n - 1) / iuse[8])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[8]) ^ nisu1 - 1) / (iuse[8] * ((1 + iuse[8]) ^ nisu1)))
A_F <- (iuse[8] / (((1 + iuse[8]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[8] * ((1 + iuse[8]) ^ nisu1)) / (((1 + iuse[8]) ^ nisu1) - 1))
P_G <- (1 / iuse[8]) * (((((1 + iuse[8]) ^ n) - 1) / (iuse[8] * ((1 + iuse[8]) ^ n))) - (n / (1 + iuse[8]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[8]) - (n / (((1 + iuse[8]) ^ n) - 1)))
A_G <- c(A_G, NA)
i4 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i4 <- round(i4, digits = 6)
setnames(i4, columns)
save(i4, file = "./data/i4.rda")


# interest of 5.00%
F_P <- ((1 + iuse[9]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[9])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[9]) ^ n - 1) / iuse[9])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[9]) ^ nisu1 - 1) / (iuse[9] * ((1 + iuse[9]) ^ nisu1)))
A_F <- (iuse[9] / (((1 + iuse[9]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[9] * ((1 + iuse[9]) ^ nisu1)) / (((1 + iuse[9]) ^ nisu1) - 1))
P_G <- (1 / iuse[9]) * (((((1 + iuse[9]) ^ n) - 1) / (iuse[9] * ((1 + iuse[9]) ^ n))) - (n / (1 + iuse[9]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[9]) - (n / (((1 + iuse[9]) ^ n) - 1)))
A_G <- c(A_G, NA)
i5 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i5 <- round(i5, digits = 6)
setnames(i5, columns)
save(i5, file = "./data/i5.rda")


# interest of 6.00%
F_P <- ((1 + iuse[10]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[10])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[10]) ^ n - 1) / iuse[10])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[10]) ^ nisu1 - 1) / (iuse[10] * ((1 + iuse[10]) ^ nisu1)))
A_F <- (iuse[10] / (((1 + iuse[10]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[10] * ((1 + iuse[10]) ^ nisu1)) / (((1 + iuse[10]) ^ nisu1) - 1))
P_G <- (1 / iuse[10]) * (((((1 + iuse[10]) ^ n) - 1) / (iuse[10] * ((1 + iuse[10]) ^ n))) - (n / (1 + iuse[10]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[10]) - (n / (((1 + iuse[10]) ^ n) - 1)))
A_G <- c(A_G, NA)
i6 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i6 <- round(i6, digits = 6)
setnames(i6, columns)
save(i6, file = "./data/i6.rda")


# interest of 7.00%
F_P <- ((1 + iuse[11]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[11])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[11]) ^ n - 1) / iuse[11])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[11]) ^ nisu1 - 1) / (iuse[11] * ((1 + iuse[11]) ^ nisu1)))
A_F <- (iuse[11] / (((1 + iuse[11]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[11] * ((1 + iuse[11]) ^ nisu1)) / (((1 + iuse[11]) ^ nisu1) - 1))
P_G <- (1 / iuse[11]) * (((((1 + iuse[11]) ^ n) - 1) / (iuse[11] * ((1 + iuse[11]) ^ n))) - (n / (1 + iuse[11]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[11]) - (n / (((1 + iuse[11]) ^ n) - 1)))
A_G <- c(A_G, NA)
i7 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i7 <- round(i7, digits = 6)
setnames(i7, columns)
save(i7, file = "./data/i7.rda")


# interest of 8.00%
F_P <- ((1 + iuse[12]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[12])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[12]) ^ n - 1) / iuse[12])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[12]) ^ nisu2 - 1) / (iuse[12] * ((1 + iuse[12]) ^ nisu2)))
A_F <- (iuse[12] / (((1 + iuse[12]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[12] * ((1 + iuse[12]) ^ nisu2)) / (((1 + iuse[12]) ^ nisu2) - 1))
P_G <- (1 / iuse[12]) * (((((1 + iuse[12]) ^ n) - 1) / (iuse[12] * ((1 + iuse[12]) ^ n))) - (n / (1 + iuse[12]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[12]) - (n / (((1 + iuse[12]) ^ n) - 1)))
A_G <- c(A_G, NA)
i8 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i8 <- round(i8, digits = 6)
setnames(i8, columns)
save(i8, file = "./data/i8.rda")


# interest of 9.00%
F_P <- ((1 + iuse[13]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[13])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[13]) ^ n - 1) / iuse[13])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[13]) ^ nisu2 - 1) / (iuse[13] * ((1 + iuse[13]) ^ nisu2)))
A_F <- (iuse[13] / (((1 + iuse[13]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[13] * ((1 + iuse[13]) ^ nisu2)) / (((1 + iuse[13]) ^ nisu2) - 1))
P_G <- (1 / iuse[13]) * (((((1 + iuse[13]) ^ n) - 1) / (iuse[13] * ((1 + iuse[13]) ^ n))) - (n / (1 + iuse[13]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[13]) - (n / (((1 + iuse[13]) ^ n) - 1)))
A_G <- c(A_G, NA)
i9 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i9 <- round(i9, digits = 6)
setnames(i9, columns)
save(i9, file = "./data/i9.rda")


# interest of 10.00%
F_P <- ((1 + iuse[14]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[14])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[14]) ^ n - 1) / iuse[14])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[14]) ^ nisu2 - 1) / (iuse[14] * ((1 + iuse[14]) ^ nisu2)))
A_F <- (iuse[14] / (((1 + iuse[14]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[14] * ((1 + iuse[14]) ^ nisu2)) / (((1 + iuse[14]) ^ nisu2) - 1))
P_G <- (1 / iuse[14]) * (((((1 + iuse[14]) ^ n) - 1) / (iuse[14] * ((1 + iuse[14]) ^ n))) - (n / (1 + iuse[14]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[14]) - (n / (((1 + iuse[14]) ^ n) - 1)))
A_G <- c(A_G, NA)
i10 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i10 <- round(i10, digits = 6)
setnames(i10, columns)
save(i10, file = "./data/i10.rda")


# interest of 12.00%
F_P <- ((1 + iuse[15]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[15])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[15]) ^ n - 1) / iuse[15])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[15]) ^ nisu2 - 1) / (iuse[15] * ((1 + iuse[15]) ^ nisu2)))
A_F <- (iuse[15] / (((1 + iuse[15]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[15] * ((1 + iuse[15]) ^ nisu2)) / (((1 + iuse[15]) ^ nisu2) - 1))
P_G <- (1 / iuse[15]) * (((((1 + iuse[15]) ^ n) - 1) / (iuse[15] * ((1 + iuse[15]) ^ n))) - (n / (1 + iuse[15]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[15]) - (n / (((1 + iuse[15]) ^ n) - 1)))
A_G <- c(A_G, NA)
i12 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i12 <- round(i12, digits = 6)
setnames(i12, columns)
save(i12, file = "./data/i12.rda")


# interest of 15.00%
F_P <- ((1 + iuse[16]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[16])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[16]) ^ n - 1) / iuse[16])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[16]) ^ nisu2 - 1) / (iuse[16] * ((1 + iuse[16]) ^ nisu2)))
A_F <- (iuse[16] / (((1 + iuse[16]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[16] * ((1 + iuse[16]) ^ nisu2)) / (((1 + iuse[16]) ^ nisu2) - 1))
P_G <- (1 / iuse[16]) * (((((1 + iuse[16]) ^ n) - 1) / (iuse[16] * ((1 + iuse[16]) ^ n))) - (n / (1 + iuse[16]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[16]) - (n / (((1 + iuse[16]) ^ n) - 1)))
A_G <- c(A_G, NA)
i15 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i15 <- round(i15, digits = 6)
setnames(i15, columns)
save(i15, file = "./data/i15.rda")


# interest of 18.00%
F_P <- ((1 + iuse[17]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[17])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[17]) ^ n - 1) / iuse[17])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[17]) ^ nisu2 - 1) / (iuse[17] * ((1 + iuse[17]) ^ nisu2)))
A_F <- (iuse[17] / (((1 + iuse[17]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[17] * ((1 + iuse[17]) ^ nisu2)) / (((1 + iuse[17]) ^ nisu2) - 1))
P_G <- (1 / iuse[17]) * (((((1 + iuse[17]) ^ n) - 1) / (iuse[17] * ((1 + iuse[17]) ^ n))) - (n / (1 + iuse[17]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[17]) - (n / (((1 + iuse[17]) ^ n) - 1)))
A_G <- c(A_G, NA)
i18 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i18 <- round(i18, digits = 6)
setnames(i18, columns)
save(i18, file = "./data/i18.rda")


# interest of 20.00%
F_P <- ((1 + iuse[18]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[18])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[18]) ^ n - 1) / iuse[18])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[18]) ^ nisu2 - 1) / (iuse[18] * ((1 + iuse[18]) ^ nisu2)))
A_F <- (iuse[18] / (((1 + iuse[18]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[18] * ((1 + iuse[18]) ^ nisu2)) / (((1 + iuse[18]) ^ nisu2) - 1))
P_G <- (1 / iuse[18]) * (((((1 + iuse[18]) ^ n) - 1) / (iuse[18] * ((1 + iuse[18]) ^ n))) - (n / (1 + iuse[18]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[18]) - (n / (((1 + iuse[18]) ^ n) - 1)))
A_G <- c(A_G, NA)
i20 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i20 <- round(i20, digits = 6)
setnames(i20, columns)
save(i20, file = "./data/i20.rda")


# interest of 25.00%
F_P <- ((1 + iuse[19]) ^ n)
F_P <- c(F_P, NA)
P_F <- ((1 / (1 + iuse[19])) ^ n)
P_F <- c(P_F, NA)
F_A <- (((1 + iuse[19]) ^ n - 1) / iuse[19])
F_A <- c(F_A, NA)
P_A <- (((1 + iuse[19]) ^ nisu2 - 1) / (iuse[19] * ((1 + iuse[19]) ^ nisu2)))
A_F <- (iuse[19] / (((1 + iuse[19]) ^ n) - 1))
A_F <- c(A_F, NA)
A_P <- ((iuse[19] * ((1 + iuse[19]) ^ nisu2)) / (((1 + iuse[19]) ^ nisu2) - 1))
P_G <- (1 / iuse[19]) * (((((1 + iuse[19]) ^ n) - 1) / (iuse[19] * ((1 + iuse[19]) ^ n))) - (n / (1 + iuse[19]) ^ n))
P_G <- c(P_G, NA)
A_G <- ((1 / iuse[19]) - (n / (((1 + iuse[19]) ^ n) - 1)))
A_G <- c(A_G, NA)
i25 <- data.table(nis, F_P, P_F, F_A, P_A, A_F, A_P, P_G, A_G, nis)
i25 <- round(i25, digits = 6)
setnames(i25, columns)
save(i25, file = "./data/i25.rda")



# Continuous
n <- c(1:30, seq(35, 100, by = 5))
r <- c(8, 10, 20)
ruse <- r / 100

columns <- c("n", "F/P", "P/F", "F/A", "P/A", "n")

# rate of 8%
F_Pr <- exp(ruse[1] * n)
P_Fr <- exp(-ruse[1] * n)
F_Ar <- ((exp(ruse[1] * n) - 1) / (exp(ruse[1]) - 1))
P_Ar <- ((exp(ruse[1] * n) - 1) / (exp(ruse[1] * n) * (exp(ruse[1]) - 1)))
r8 <- data.table(n, F_Pr, P_Fr, F_Ar, P_Ar, n)
r8 <- round(r8, digits = 6)
setnames(r8, columns)
save(r8, file = "./data/r8.rda")


# rate of 10%
F_Pr <- exp(ruse[2] * n)
P_Fr <- exp(-ruse[2] * n)
F_Ar <- ((exp(ruse[2] * n) - 1) / (exp(ruse[2]) - 1))
P_Ar <- ((exp(ruse[2] * n) - 1) / (exp(ruse[2] * n) * (exp(ruse[2]) - 1)))
r10 <- data.table(n, F_Pr, P_Fr, F_Ar, P_Ar, n)
r10 <- round(r10, digits = 6)
setnames(r10, columns)
save(r10, file = "./data/r10.rda")


# rate of 20%
F_Pr <- exp(ruse[3] * n)
P_Fr <- exp(-ruse[3] * n)
F_Ar <- ((exp(ruse[3] * n) - 1) / (exp(ruse[3]) - 1))
P_Ar <- ((exp(ruse[3] * n) - 1) / (exp(ruse[3] * n) * (exp(ruse[3]) - 1)))
r20 <- data.table(n, F_Pr, P_Fr, F_Ar, P_Ar, n)
r20 <- round(r20, digits = 6)
setnames(r20, columns)
save(r20, file = "./data/r20.rda")



# Reference
# William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 625-647.
# Masoud Olia, Ph.D., P.E. and Contributing Authors, \emph{Barron's FE (Fundamentals of Engineering Exam)}, 3rd Edition, Hauppauge, New York: Barron's Educational Series, Inc., 2015, page 178-187.

# Source 1
# https://stackoverflow.com/questions/33584387/avoid-scientific-notation-for-small-numbers
# r - avoid scientific notation for small numbers - Stack Overflow
