% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_degree_betweenness.R
\name{cluster_degree_betweenness}
\alias{cluster_degree_betweenness}
\title{Community structure detection based on node degree centrality and edge betweenness}
\usage{
cluster_degree_betweenness(graph)
}
\arguments{
\item{graph}{The graph to analyze}
}
\value{
An igraph "communities" object with detected communities via the Smith-Pittman algorithm.
}
\description{
Referred to as the "Smith-Pittman" algorithm in Smith et al (2024). This algorithm detects communities by calculating the degree centrality measures of nodes and edge betweenness.
}
\details{
This can be thought of as an alternative version of \code{igraph::cluster_edge_betweeness()}.

The function iteratively removes edges based on their betweenness centrality and the degree of their adjacent nodes. At each iteration, it identifies the edge with the highest betweenness centrality among those connected to nodes with the highest degree.It then removes that edge and recalculates the modularity of the resulting graph. The process continues until all edges have been assessed or until no further subgraph can be created with the optimal number of communites being chosen based on maximization of modularity.
}
\examples{
library(igraphdata)
data("karate")
ndb <- cluster_degree_betweenness(karate)
plot(
ndb,
karate,
main= "Degree-Betweenness Clustering"
)

ndb

# UNLABELED GRAPH EXAMPLE

data("UKfaculty")
# Making graph undirected so it looks nicer when its plotted
uk_faculty <- prep_unlabeled_graph(UKfaculty) |>
  igraph::as.undirected()

ndb <- cluster_degree_betweenness(uk_faculty)

plot(
  ndb,
  uk_faculty,
  main= "Smith-Pittman Clustering for UK Faculty"
)

}
\references{
Smith et al (2024) "Centrality in Collaboration: A Novel Algorithm for Social Partitioning Gradients in Community Detection for Multiple Oncology Clinical Trial Enrollments", <doi:10.48550/arXiv.2411.01394>
}
