`ksig` <-
function(x,kernel="normal",
alternative="two.sided",graph=TRUE,xlab=NULL,ylab=NULL){
plot<-graph
alter<-alternative
ker<-kernel
if(kernel=="normal"){
estimate<-mleig(x,kernel="normal")
mu<-estimate$mu
lambda<-estimate$lambda
ks<-ks.test(x,"pig",alternative=alter,mu=mu,lambda=lambda)
}
if(kernel=="logistic"){
estimate<-mleig(x,kernel="logistic")
mu<-estimate$mu
lambda<-estimate$lambda
ks<-ks.test(x,"pig",alternative=alter,mu=mu,lambda=lambda)
}
if(kernel=="Laplace"){
estimate<-mleig(x,kernel="Laplace")
mu<-estimate$mu
lambda<-estimate$lambda
ks<-ks.test(x,"pig",alternative=alter,mu=mu,lambda=lambda)
}
if(kernel=="t"){
estimate<-mleig(x,kernel="t")
mu<-estimate$mu
lambda<-estimate$lambda
nu<-estimate$nu
nu.fixed<-nu
ks<-ks.test(x,"pig",alternative=alter,mu=mu,lambda=lambda,parameter.nu=nu)
}
if(plot==TRUE){
plot(ecdf(x),do.points=FALSE,main="",xlab=xlab,ylab=ylab,lwd=2.0,col.01line=3,las=1)
mini<-min(x)
maxi<-max(x)
t<-seq(mini,maxi,by=0.1)
y<-pig(t,mu,lambda,kernel=ker,nu.fixed)
lines(t,y,col=2,lwd=2.0)
}
return(ks)
}

