% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mage_ma_single.R
\name{mage_ma_single}
\alias{mage_ma_single}
\title{Calculates Mean Amplitude of Glycemic Excursions (see "mage")}
\usage{
mage_ma_single(
  data,
  short_ma = 5,
  long_ma = 23,
  type = c("auto", "plus", "minus"),
  plot = FALSE,
  interval = NA,
  dateformat = "\%Y-\%m-\%d \%H:\%M:\%S",
  title = NA,
  xlab = NA,
  ylab = NA,
  show_ma = FALSE
)
}
\arguments{
\item{data}{Data Frame object with column names "id", "time", and "gl" OR numeric vector of glucose values (plot won't work with vector)}

\item{short_ma}{Integer for period length of the short moving average. Must be positive and less than "long_ma". (Recommended <15)}

\item{long_ma}{Integer for period length for the long moving average. (Recommended >20)}

\item{type}{One of "plus", "minus", "auto" (Default: auto). Algorithm will either calculate MAGE+ (nadir to peak), MAGE- (peak to nadir), or automatically choose based on the first countable excursion.}

\item{plot}{Boolean. Returns ggplot if TRUE.}

\item{interval}{Integer for time interval in minutes between glucose readings. Function will auto-magically determine the interval if not specified. (Only used to calculate the gaps shown on the ggplot)}

\item{dateformat}{POSIXct time format for time of glucose readings. Highly recommended to set if glucose times are in a different format.}

\item{title}{Title for the ggplot. Defaults to "Glucose Trace - Subject [ID]"}

\item{xlab}{Label for x-axis of ggplot. Defaults to "Time"}

\item{ylab}{Label for y-axis of ggplot. Defaults to "Glucose Level"}

\item{show_ma}{Whether to show the moving average lines on the plot or not}
}
\value{
The numeric MAGE value for the inputted glucose values or a ggplot if \code{plot = TRUE}
}
\description{
This function is an internal function used by "mage". The function will calculate the Mean Amplitude of Glycemic Excursions (MAGE) on \strong{all} the values of the inputted data set. To calculate separate MAGE values for a group of subjects, use the "mage" function.
}
\details{
See "mage".
}
\examples{
data(example_data_5_subject)
mage_ma_single(
   example_data_5_subject,
   short_ma = 4,
   long_ma = 24,
   type = 'plus')

mage_ma_single(
   example_data_5_subject,
   dateformat="\%m-\%d-\%Y \%H:\%M:\%S")

mage_ma_single(
   example_data_5_subject,
   plot=TRUE,
   interval=15,
   title="Patient X",
   xlab="Time",
   ylab="Glucose Level (mg/dL)",
   show_ma=FALSE)
}
\author{
Nathaniel Fernandes
}
