% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adrr.R
\name{adrr}
\alias{adrr}
\title{Calculate average daily risk range (ADRR)}
\usage{
adrr(data)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}
}
\value{
A tibble object with two columns: subject id and corresponding
ADRR value.
}
\description{
The function adrr produces ADRR values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for ADRR values is returned. NA glucose values are
omitted from the calculation of the ADRR values.

ADRR is the average sum of HBGI corresponding to the highest glucose
value and LBGI corresponding to the lowest glucose value for each day,
with the average taken over the daily sums. If there are no high glucose or
no low glucose values, then 0 will be substituted for the HBGI value or the
LBGI value, respectively, for that day.
}
\examples{

data(example_data_1_subject)
adrr(example_data_1_subject)

data(example_data_5_subject)
adrr(example_data_5_subject)

}
\references{
Kovatchev et al. (2006) Evaluation of a New Measure of Blood Glucose Variability in,
Diabetes
\emph{Diabetes care} \strong{29} .2433-2438,
\doi{10.2337/dc06-1085}.
}
