% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_glu.R
\name{cv_glu}
\alias{cv_glu}
\title{Calculate Coefficient of Variation (CV) of glucose levels}
\usage{
cv_glu(data)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding CV value is returned. If a vector of glucose
values is passed, then a tibble object with just the CV value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function cv_glu produces CV values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for CV values is returned. NA glucose values are
omitted from the calculation of the CV.

CV (Coefficient of Variation) is calculated by \eqn{100 * sd(G) / mean(G)}
Where G is the list of all Glucose measurements for a subject.
}
\examples{

data(example_data_1_subject)
cv_glu(example_data_1_subject)

data(example_data_5_subject)
cv_glu(example_data_5_subject)

}
\references{
Rodbard (2009) Interpretation of continuous glucose monitoring data:
glycemic variability and quality of glycemic control,
\emph{Diabetes Technology and Therapeutics} \strong{11} .55-67,
\doi{10.1089/dia.2008.0132}.
}
