% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/interface.R
\name{adjacent_vertices}
\alias{adjacent_vertices}
\title{Adjacent vertices of multiple vertices in a graph}
\usage{
adjacent_vertices(graph, v, mode = c("out", "in", "all", "total"))
}
\arguments{
\item{graph}{Input graph.}

\item{v}{The vertices to query.}

\item{mode}{Whether to query outgoing (\sQuote{out}), incoming
(\sQuote{in}) edges, or both types (\sQuote{all}). This is
ignored for undirected graphs.}
}
\value{
A list of vertex sequences.
}
\description{
This function is similar to \code{\link{neighbors}}, but it queries
the adjacent vertices for multiple vertices at once.
}
\examples{
g <- make_graph("Zachary")
adjacent_vertices(g, c(1, 34))
}
\seealso{
Other structural queries: \code{\link{[.igraph}};
  \code{\link{[[.igraph}}; \code{\link{are.connected}},
  \code{\link{are_adjacent}}; \code{\link{ecount}},
  \code{\link{gsize}}; \code{\link{ends}},
  \code{\link{get.edge}}, \code{\link{get.edges}};
  \code{\link{get.edge.ids}}; \code{\link{gorder}},
  \code{\link{vcount}}; \code{\link{head_of}};
  \code{\link{incident_edges}}; \code{\link{incident}};
  \code{\link{is.directed}}, \code{\link{is_directed}};
  \code{\link{neighbors}}; \code{\link{tail_of}}
}

