% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_with_gem}
\alias{layout.gem}
\alias{layout_with_gem}
\alias{with_gem}
\title{The GEM layout algorithm}
\usage{
layout_with_gem(graph, coords = NULL, maxiter = 40 * vcount(graph)^2,
  temp.max = vcount(graph), temp.min = 1/10,
  temp.init = sqrt(vcount(graph)))

with_gem(...)
}
\arguments{
\item{graph}{The input graph. Edge directions are ignored.}

\item{coords}{If not \code{NULL}, then the starting coordinates should be
given here, in a two or three column matrix, depending on the \code{dim}
argument.}

\item{maxiter}{The maximum number of iterations to perform. Updating a
single vertex counts as an iteration.  A reasonable default is 40 * n * n,
where n is the number of vertices. The original paper suggests 4 * n * n,
but this usually only works if the other parameters are set up carefully.}

\item{temp.max}{The maximum allowed local temperature. A reasonable default
is the number of vertices.}

\item{temp.min}{The global temperature at which the algorithm terminates
(even before reaching \code{maxiter} iterations). A reasonable default is
1/10.}

\item{temp.init}{Initial local temperature of all vertices. A reasonable
default is the square root of the number of vertices.}

\item{...}{Passed to \code{layout_with_gem}.}
}
\value{
A numeric matrix with two columns, and as many rows as the number of
vertices.
}
\description{
Place vertices on the plane using the GEM force-directed layout algorithm.
}
\details{
See the referenced paper below for the details of the algorithm.
}
\examples{
set.seed(42)
g <- make_ring(10)
plot(g, layout=layout_with_gem)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\references{
Arne Frick, Andreas Ludwig, Heiko Mehldau: A Fast Adaptive
Layout Algorithm for Undirected Graphs, \emph{Proc. Graph Drawing 1994},
LNCS 894, pp. 388-403, 1995.
}
\seealso{
\code{\link{layout_with_fr}},
\code{\link{plot.igraph}}, \code{\link{tkplot}}

Other graph layouts: \code{\link{add_layout_}};
  \code{\link{as_bipartite}},
  \code{\link{layout.bipartite}},
  \code{\link{layout_as_bipartite}}; \code{\link{as_star}},
  \code{\link{layout.star}}, \code{\link{layout_as_star}};
  \code{\link{as_tree}}, \code{\link{layout_as_tree}};
  \code{\link{component_wise}}; \code{\link{in_circle}},
  \code{\link{layout_in_circle}};
  \code{\link{layout.auto}}, \code{\link{layout_nicely}},
  \code{\link{nicely}};
  \code{\link{layout.davidson.harel}},
  \code{\link{layout_with_dh}}, \code{\link{with_dh}};
  \code{\link{layout.graphopt}},
  \code{\link{layout_with_graphopt}},
  \code{\link{with_graphopt}}; \code{\link{layout.grid}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout_on_grid}}, \code{\link{on_grid}};
  \code{\link{layout.mds}}, \code{\link{layout_with_mds}},
  \code{\link{with_mds}}; \code{\link{layout.merge}},
  \code{\link{layout_components}},
  \code{\link{merge_coords}},
  \code{\link{piecewise.layout}},
  \code{\link{piecewise.layout}};
  \code{\link{layout.norm}}, \code{\link{norm_coords}};
  \code{\link{layout.sugiyama}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{with_sugiyama}};
  \code{\link{layout_on_sphere}}, \code{\link{on_sphere}};
  \code{\link{layout_randomly}}, \code{\link{randomly}};
  \code{\link{layout_with_fr}}, \code{\link{with_fr}};
  \code{\link{layout_with_kk}}, \code{\link{with_kk}};
  \code{\link{layout_with_lgl}}, \code{\link{with_lgl}};
  \code{\link{layout}}, \code{\link{layout_}},
  \code{\link{print.igraph_layout_modifier}},
  \code{\link{print.igraph_layout_spec}};
  \code{\link{normalize}}
}
\keyword{graphs}

