% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{gsize}
\alias{gsize}
\alias{ecount}
\title{The size of the graph (number of edges)}
\usage{
gsize(graph)
}
\arguments{
\item{graph}{The graph.}
}
\value{
Numeric scalar, the number of edges.
}
\description{
\code{ecount} of an alias of this function.
}
\examples{
g <- sample_gnp(100, 2/100)
gsize(g)

# Number of edges in a G(n,p) graph
replicate(100, sample_gnp(10, 1/2), simplify = FALSE) \%>\%
  vapply(gsize, 0) \%>\%
  hist()
}
\seealso{
Other structural queries: \code{\link{[.igraph}},
  \code{\link{[[.igraph}}, \code{\link{adjacent_vertices}},
  \code{\link{are_adjacent}}, \code{\link{ends}},
  \code{\link{get.edge.ids}}, \code{\link{gorder}},
  \code{\link{head_of}}, \code{\link{incident_edges}},
  \code{\link{incident}}, \code{\link{is_directed}},
  \code{\link{neighbors}}, \code{\link{tail_of}}
}
\concept{structural queries}
