% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_as_tree}
\alias{layout_as_tree}
\alias{as_tree}
\title{The Reingold-Tilford graph layout algorithm}
\usage{
layout_as_tree(graph, root = numeric(), circular = FALSE,
  rootlevel = numeric(), mode = c("out", "in", "all"), flip.y = TRUE)

as_tree(...)
}
\arguments{
\item{graph}{The input graph.}

\item{root}{The index of the root vertex or root vertices.  If this is a
non-empty vector then the supplied vertex ids are used as the roots of the
trees (or a single tree if the graph is connected).  If it is an empty
vector, then the root vertices are automatically calculated based on
topological sorting, performed with the opposite mode than the \code{mode}
argument. After the vertices have been sorted, one is selected from each
component.}

\item{circular}{Logical scalar, whether to plot the tree in a circular
fashion. Defaults to \code{FALSE}, so the tree branches are going bottom-up
(or top-down, see the \code{flip.y} argument.}

\item{rootlevel}{This argument can be useful when drawing forests which are
not trees (i.e. they are unconnected and have tree components). It specifies
the level of the root vertices for every tree in the forest. It is only
considered if the \code{roots} argument is not an empty vector.}

\item{mode}{Specifies which edges to consider when building the tree.  If it
is \sQuote{out}, then only the outgoing, if it is \sQuote{in}, then only the
incoming edges of a parent are considered. If it is \sQuote{all} then all
edges are used (this was the behavior in igraph 0.5 and before). This
parameter also influences how the root vertices are calculated, if they are
not given. See the \code{roots} parameter.}

\item{flip.y}{Logical scalar, whether to flip the \sQuote{y} coordinates.
The default is flipping because that puts the root vertex on the top.}

\item{...}{Passed to \code{layout_as_tree}.}
}
\value{
A numeric matrix with two columns, and one row for each vertex.
}
\description{
A tree-like layout, it is perfect for trees, acceptable for graphs with not
too many cycles.
}
\details{
Arranges the nodes in a tree where the given node is used as the root.  The
tree is directed downwards and the parents are centered above its children.
For the exact algorithm, the refernce below.

If the given graph is not a tree, a breadth-first search is executed first
to obtain a possible spanning tree.
}
\examples{

tree <- make_tree(20, 3)
plot(tree, layout=layout_as_tree)
plot(tree, layout=layout_as_tree(tree, flip.y=FALSE))
plot(tree, layout=layout_as_tree(tree, circular=TRUE))

tree2 <- make_tree(10, 3) + make_tree(10, 2)
plot(tree2, layout=layout_as_tree)
plot(tree2, layout=layout_as_tree(tree2, root=c(1,11),
                                           rootlevel=c(2,1)))
}
\references{
Reingold, E and Tilford, J (1981). Tidier drawing of trees.
\emph{IEEE Trans. on Softw. Eng.}, SE-7(2):223--228.
}
\seealso{
Other graph layouts: \code{\link{add_layout_}},
  \code{\link{component_wise}},
  \code{\link{layout_as_bipartite}},
  \code{\link{layout_as_star}},
  \code{\link{layout_in_circle}},
  \code{\link{layout_nicely}},
  \code{\link{layout_on_grid}},
  \code{\link{layout_on_sphere}},
  \code{\link{layout_randomly}},
  \code{\link{layout_with_dh}},
  \code{\link{layout_with_fr}},
  \code{\link{layout_with_gem}},
  \code{\link{layout_with_graphopt}},
  \code{\link{layout_with_kk}},
  \code{\link{layout_with_lgl}},
  \code{\link{layout_with_mds}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{layout_}}, \code{\link{merge_coords}},
  \code{\link{norm_coords}}, \code{\link{normalize}}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
