% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{difference.igraph.es}
\alias{difference.igraph.es}
\title{Difference of edge sequences}
\usage{
\method{difference}{igraph.es}(big, small, ...)
}
\arguments{
\item{big}{The \sQuote{big} edge sequence.}

\item{small}{The \sQuote{small} edge sequence.}

\item{...}{Ignored, included for S3 signature compatibility.}
}
\value{
An edge sequence that contains only edges that are part of
\code{big}, but not part of \code{small}.
}
\description{
Difference of edge sequences
}
\details{
They must belong to the same graph. Note that this function has
\sQuote{set} semantics and the multiplicity of edges is lost in the
result.
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
difference(V(g), V(g)[6:10])
}
\seealso{
Other vertex and edge sequence operations: 
\code{\link{c.igraph.es}()},
\code{\link{c.igraph.vs}()},
\code{\link{difference.igraph.vs}()},
\code{\link{igraph-es-indexing2}},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-vs-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{intersection.igraph.es}()},
\code{\link{intersection.igraph.vs}()},
\code{\link{rev.igraph.es}()},
\code{\link{rev.igraph.vs}()},
\code{\link{union.igraph.es}()},
\code{\link{union.igraph.vs}()},
\code{\link{unique.igraph.es}()},
\code{\link{unique.igraph.vs}()}
}
\concept{vertex and edge sequence operations}
