% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{walktrap.community}
\alias{walktrap.community}
\title{Community structure via short random walks}
\usage{
walktrap.community(
  graph,
  weights = NULL,
  steps = 4,
  merges = TRUE,
  modularity = TRUE,
  membership = TRUE
)
}
\arguments{
\item{graph}{The input graph. Edge directions are ignored in directed
graphs.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. Larger edge
weights increase the probability that an edge is selected by the random
walker. In other words, larger edge weights correspond to stronger connections.}

\item{steps}{The length of the random walks to perform.}

\item{merges}{Logical scalar, whether to include the merge matrix in the
result.}

\item{modularity}{Logical scalar, whether to include the vector of the
modularity scores in the result. If the \code{membership} argument is true,
then it will always be calculated.}

\item{membership}{Logical scalar, whether to calculate the membership vector
for the split corresponding to the highest modularity value.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{walktrap.community()} was renamed to \code{\link[=cluster_walktrap]{cluster_walktrap()}} to create a more
consistent API.
}
\keyword{internal}
