% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendogram.R
\name{add_col_dendro}
\alias{add_col_dendro}
\alias{add_col_dendro,Iheatmap,hclust-method}
\title{add_col_dendro}
\usage{
\S4method{add_col_dendro}{Iheatmap,hclust}(
  p,
  dendro,
  reorder = TRUE,
  side = c("top", "bottom"),
  size = 0.15,
  buffer = 0.005,
  xname = current_xaxis(p),
  yname = NULL,
  sname = "col_dendro"
)
}
\arguments{
\item{p}{iheatmap object}

\item{dendro}{hclust object}

\item{reorder}{reorder rows based on dendrogram order?}

\item{side}{side of plot on which to add dendro}

\item{size}{relative size of dendrogram (relative to the main heatmap)}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{sname}{internal name of shape}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds column dendrogram to iheatmap object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
dend <- hclust(dist(t(mat)))
hm <- iheatmap(mat) \%>\% add_col_dendro(dend)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_col_clustering}}, \code{\link{iheatmap}}, 
\code{\link{add_row_dendro}}
}
\author{
Alicia Schep
}
