% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axes.R
\name{reorder_rows}
\alias{reorder_rows}
\alias{reorder_rows,IheatmapHorizontal,integer-method}
\alias{reorder_rows,IheatmapVertical,integer-method}
\title{reorder_rows}
\usage{
\S4method{reorder_rows}{IheatmapHorizontal,integer}(p, row_order)

\S4method{reorder_rows}{IheatmapVertical,integer}(p, row_order, yname = current_yaxis(p))
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{row_order}{integer vector}

\item{yname}{name of yaxis to reorder, only applicable if object is oriented
vertically}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Reorder the rows of an \code{\link{Iheatmap-class}} object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
dend <- hclust(dist(mat))
hm <- iheatmap(mat) \%>\% reorder_rows(dend$order)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_clustering}}, \code{\link{reorder_cols}}
}
\author{
Alicia Schep
}
