% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{imwarp}
\alias{imwarp}
\title{Image warping}
\usage{
imwarp(im, map, direction = "forward", coordinates = "absolute",
  boundary = "dirichlet", interpolation = "linear")
}
\arguments{
\item{im}{an image}

\item{map}{a function that takes (x,y) or (x,y,z) as arguments and returns a named list with members (x,y) or (x,y,z)}

\item{direction}{"forward" or "backward" (default "forward")}

\item{coordinates}{"absolute" or "relative" (default "relative")}

\item{boundary}{boundary conditions: "dirichlet", "neumann", "periodic". Default "dirichlet"}

\item{interpolation}{"nearest", "linear", "cubic" (default "linear")}
}
\value{
a warped image
}
\description{
Image warping consists in remapping pixels, ie. you define a function
M(x,y,z) -> (x',y',z')
that displaces pixel content from (x,y,z) to (x',y',z').
Actual implementations rely on either the forward transformation M, or the backward (inverse) transformation M^-1.
In CImg the forward implementation will go through all source (x,y,z) pixels and "paint" the corresponding pixel at (x',y',z'). This will result in unpainted pixels in the output if M is expansive (for example in the case of a scaling M(x,y,z) = 5*(x,y,z)).
The backward implementation will go through every pixel in the destination image and look for ancestors in the source, meaning that every pixel will be painted.
There are two ways of specifying the map: absolute or relative coordinates. In absolute coordinates you specify M or M^-1 directly. In relative coordinates you specify an offset function D:
M(x,y) = (x,y) + D(x,y) (forward)
M^-1(x,y) = (x,y) - D(x,y) (backward)
}
\details{
Note that 3D warps are possible as well.
The mapping should be specified via the "map" argument, see examples.
}
\examples{
im <- load.image(system.file('extdata/parrots.png',package='imager'))
#Shift image
map.shift <- function(x,y) list(x=x+10,y=y+30)
imwarp(im,map=map.shift) \%>\% plot
#Shift image (backward transform)
imwarp(im,map=map.shift,dir="backward") \%>\% plot

#Shift using relative coordinates
map.rel <- function(x,y) list(x=10+0*x,y=30+0*y)
imwarp(im,map=map.rel,coordinates="relative") \%>\% plot

#Scaling
map.scaling <- function(x,y) list(x=1.5*x,y=1.5*y)
imwarp(im,map=map.scaling) \%>\% plot #Note the holes
map.scaling.inv <- function(x,y) list(x=x/1.5,y=y/1.5)
imwarp(im,map=map.scaling.inv,dir="backward") \%>\% plot #No holes

#Bending
map.bend.rel <- function(x,y) list(x=50*sin(y/10),y=0*y)
imwarp(im,map=map.bend.rel,coord="relative",dir="backward") \%>\% plot #No holes
}
\author{
Simon Barthelme
}
\seealso{
warp for direct access to the CImg function
}

