% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{interp}
\alias{interp}
\title{Interpolate image values}
\usage{
interp(im, locations, cubic = FALSE)
}
\arguments{
\item{im}{the image (class cimg)}

\item{locations}{a data.frame}

\item{cubic}{if TRUE, use cubic interpolation. If FALSE, use linear (default FALSE)}
}
\description{
This function provides 2D and 3D (linear or cubic) interpolation for pixel values.
Locations need to be provided as a data.frame with variables x,y,z, and c (the last two are optional).
}
\examples{
im <- load.image(system.file('extdata/parrots.png',package='imager'))
loc <- data.frame(x=runif(10,1,width(im)),y=runif(10,1,height(im))) #Ten random locations
interp(im,loc)
}

