% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{as.igraph.pixset}
\alias{as.igraph.pixset}
\title{Form an adjacency graph from a pixset}
\usage{
\method{as.igraph}{pixset}(x, weighted = TRUE, ...)
}
\arguments{
\item{x}{a pixset}

\item{weighted}{add weight for distance (default TRUE)}

\item{...}{ignored}
}
\value{
an igraph "graph" object
}
\description{
Return a graph where nodes are pixels, and two nodes are connected if and only if both nodes are in the pixset, and the pixels are adjacent. Optionnally, add weights corresponding to distance (either 1 or sqrt(2), depending on the orientation of the edge).
The graph is represented as an igraph "graph" object
}
\examples{
library(igraph)
#Simple 3x3 lattice
px <- px.all(imfill(3,3))
as.igraph(px) \%>\% plot
#Disconnect central pixel
px[5] <- FALSE
as.igraph(px) \%>\% plot
#Form graph from thresholded image
im <- load.example("coins")
px <- threshold(im) \%>\% fill(5)
G <- as.igraph(px)
#Label connected components
v <- (igraph::clusters(G)$membership)
as.cimg(v,dim=dim(px)) \%>\% plot
#Find a path across the image that avoids all
#the coins
G <- as.igraph(!px)
start <- index.coord(im,data.frame(x=1,y=100))
end <- index.coord(im,data.frame(x=384,y=300))
sp <- igraph::shortest_paths(G,start,end,output="vpath")
path <- sp$vpath[[1]] \%>\% as.integer \%>\% coord.index(im,.)
}
\seealso{
as.igraph.cimg
}
