% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hough.R
\name{hough_circle}
\alias{hough_circle}
\title{Circle detection using Hough transform}
\usage{
hough_circle(px, radius)
}
\arguments{
\item{px}{a pixset (e.g., the output of a Canny detector)}

\item{radius}{radius of circle}
}
\value{
a histogram of Hough scores, with the same dimension as the original image.
}
\description{
Detects circles of known radius in a pixset. The output is an image where the pixel value at (x,y) represents the amount of evidence for the presence of a circle of radius r at position (x,y). 
NB: in the current implementation, does not detect circles centred outside the limits of the pixset.
}
\examples{
im <- load.example('coins')
px <- cannyEdges(im)
#Find circles of radius 20
hc <- hough_circle(px,20)
plot(hc)
#Clean up, run non-maxima suppression
nms <- function(im,sigma) { im[dilate_square(im,sigma) != im] <- 0; im}
hc.clean <- isoblur(hc,3) \%>\% nms(50)
#Top ten matches
df <- as.data.frame(hc.clean) \%>\%
dplyr::arrange(desc(value)) \%>\% head(10)
with(df,circles(x,y,20,fg="red",lwd=3))
}
\author{
Simon Barthelme
}
