% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{grab}
\alias{grab}
\alias{grabLine}
\alias{grabRect}
\alias{grabPoint}
\title{Select image regions interactively}
\usage{
grabLine(im, output = "coord")

grabRect(im, output = "coord")

grabPoint(im, output = "coord")
}
\arguments{
\item{im}{an image}

\item{output}{one of "im","pixset","coord","value". Default "coord"}
}
\value{
Depending on the value of the output parameter. Either a vector of coordinates (output = "coord"), an image (output = "im"), a pixset (output = "pixset"), or a vector of values (output = "value"). grabLine and grabPoint support the "value" output mode and not the "im" output.
}
\description{
These functions let you select a shape in an image (a point, a line, or a rectangle)
They either return the coordinates of the shape (default), or the contents.
In case of lines contents are interpolated. Note that grabLine does not support the "pixset" return type. 
Note that you need X11 library to use these functions.
}
\examples{
##Not run: interactive only 
##grabRect(boats)
##grabRect(boats,TRUE)
}
\seealso{
display
}
\author{
Simon Barthelme
}
