% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cimg.openmp}
\alias{cimg.openmp}
\alias{cimg.use.openmp}
\alias{cimg.limit.openmp}
\title{Control CImg's parallelisation}
\usage{
cimg.use.openmp(mode = "adaptive", nthreads = 1, verbose = FALSE)

cimg.limit.openmp()
}
\arguments{
\item{mode}{Either "adaptive","always" or "none". The default is adaptive (parallelisation for large images only).}

\item{nthreads}{The number of OpenMP threads that imager should use. The default is 1. Set to 0 to get no more than 2, based on OpenMP environment variables.}

\item{verbose}{Whether to output information about the threads being set.}
}
\value{
NULL (function is used for side effects)
}
\description{
On supported architectures CImg can parallelise many operations using OpenMP (e.g. \code{\link{imager.combine}}). Use this function to turn parallelisation on or off.
}
\details{
You need to be careful that \option{nthreads} is not higher than the value in the system environment variable OMP_THREAD_LIMIT (this can be checked with Sys.getenv('OMP_THREAD_LIMIT')). The OMP_THREAD_LIMIT thread limit usually needs to be correctly set before launching R, so using Sys.setenv once a session has started is not certain to work.
}
\section{Functions}{
\itemize{
\item \code{cimg.limit.openmp()}: Limit OpenMP thread count to no more than 2, based on OpenMP environment variables.

}}
\examples{
\dontshow{cimg.limit.openmp()}
cimg.use.openmp("never") #turn off parallelisation
}
\author{
Simon Barthelme
}
