% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{highlight}
\alias{highlight}
\title{Highlight pixel set on image}
\usage{
highlight(px, col = "red", ...)
}
\arguments{
\item{px}{a pixel set}

\item{col}{color of the contours}

\item{...}{passed to the "lines" function}
}
\description{
Overlay an image plot with the contours of a pixel set. Note that this function doesn't do the image plotting, just the highlighting.
}
\examples{
\dontshow{cimg.limit.openmp()}
#Select similar pixels around point (180,200)
px <- px.flood(boats,180,200,sigma=.08)
plot(boats)
#Highlight selected set
highlight(px)
px.flood(boats,18,50,sigma=.08) \%>\% highlight(col="white",lwd=3)
}
\seealso{
colorise, another way of highlighting stuff
}
\author{
Simon Barthelme
}
